/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.forms.FormResource;

public abstract class AbstractFormResourceService
extends HttpServlet {
    private static final long serialVersionUID = 3397469624880841940L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractFormResourceService.class);

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.handleRequest(req, resp, false);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.handleRequest(req, resp, true);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response, boolean deliverContent) throws ServletException, IOException {
        block19: {
            if (logger.isTraceEnabled()) {
                logger.traceEnter();
            }
            String templateFile = request.getParameter("templateFile");
            String type = request.getParameter("type");
            if (templateFile == null) {
                logger.error("handleRequest: Parameter \"templateFile\" missing");
                response.setStatus(500);
                response.getWriter().print("Internal server error: required parameter templateFile is missing.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("handleRequest: templateFile=" + templateFile);
                logger.debug("handleRequest: type=" + type);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("handleRequest: negogiating authentication");
            }
            try {
                FormResource formResource = this.getFormResource(templateFile);
                if (formResource == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("handleRequest: form resource does not exist. templateFile=" + templateFile);
                    }
                    response.setStatus(404);
                    response.setCharacterEncoding("UTF-8");
                    response.getWriter().print("404: object not found.");
                    if (logger.isTraceEnabled()) {
                        logger.traceExit();
                    }
                    return;
                }
                response.setStatus(200);
                response.setContentType("application/octet-stream");
                response.setContentLength(formResource.getSize());
                response.setHeader("Content-Disposition", "attachment;filename=\"" + formResource.getFilename() + "\"");
                if (!deliverContent) break block19;
                ServletOutputStream os = response.getOutputStream();
                InputStream is = formResource.getContent();
                try {
                    int size;
                    byte[] buffer = new byte[2048];
                    while ((size = is.read(buffer)) > 0) {
                        os.write(buffer, 0, size);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        logger.error("Error closing form resource stream", e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("handleRequest: Unexpected Exception while handling request", e);
                response.setStatus(500);
                response.getWriter().print("500: Internal server error.");
            }
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected abstract FormResource getFormResource(String var1);
}

