/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import org.alfresco.officeservices.AbstractVermeerService;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerParameterString;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;

public abstract class AbstractDispatcherService
extends AbstractVermeerService {
    private static final long serialVersionUID = -3819903947518357007L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractDispatcherService.class);
    public static final String METHODNAME_SERVER_VERSION = "server version";
    public static final String METHODNAME_URL_TO_WEB_URL = "url to web url";

    @Override
    public void vermeerService(String methodname, VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (methodname.equalsIgnoreCase(METHODNAME_SERVER_VERSION)) {
            this.vermeerServerVersion(vermeerRequest, vermeerResponse);
        } else if (methodname.equalsIgnoreCase(METHODNAME_URL_TO_WEB_URL)) {
            this.vermeerUrlToWebUrl(vermeerRequest, vermeerResponse);
        } else {
            logger.error("vermeerService: unknown RPC methodname " + methodname);
            vermeerResponse.error("unknown method key");
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void vermeerServerVersion(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        this.serverVersion(vermeerRequest, vermeerResponse);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void serverVersion(VermeerRequest var1, VermeerResponse var2) throws IOException, VermeerException, AuthenticationRequiredException;

    protected void vermeerUrlToWebUrl(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
            logger.traceRawVermeerParameter(vermeerRequest, "url");
        }
        VermeerParameterString url = new VermeerParameterString(vermeerRequest, "url", true);
        this.urlToWebUrl(vermeerRequest, vermeerResponse, url.getValue());
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public abstract void urlToWebUrl(VermeerRequest var1, VermeerResponse var2, String var3) throws IOException, VermeerException, AuthenticationRequiredException;
}

