/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.aos;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationCookiesService;
import org.alfresco.module.aosmodule.auth.service.AosIDSContextService;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.web.scripts.aos.AbstractAosWebScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AosAuthenticationSuccess
extends AbstractAosWebScript {
    private static final Logger LOG = LoggerFactory.getLogger(AosAuthenticationSuccess.class);
    private final AosAuthenticationCookiesService cookiesService;
    private final AosIDSContextService idsContextService;

    public AosAuthenticationSuccess(AosAuthenticationCookiesService cookiesService, AosIDSContextService idsContextService) {
        this.cookiesService = cookiesService;
        this.idsContextService = idsContextService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        HttpServletRequest servletRequest = this.findServletRequest(req);
        String authToken = this.cookiesService.getCookie("ALFRESCO_AOS_TOKEN", servletRequest);
        IdentityServiceFacade identityServiceFacade = this.idsContextService.getIdentityServiceBean(IdentityServiceFacade.class);
        if (identityServiceFacade != null && authToken != null) {
            try {
                identityServiceFacade.decodeToken(authToken);
                AosAuthenticationSuccess.writeResponse(res, "You are authenticated.");
            }
            catch (Exception e) {
                LOG.error("Error while trying to authenticate token: {}", (Object)e.getMessage());
                res.setStatus(401);
            }
        } else {
            res.setStatus(401);
        }
    }

    private static void writeResponse(WebScriptResponse res, String responseBody) throws IOException {
        res.setStatus(200);
        res.setContentEncoding("UTF-8");
        res.setHeader("length", String.valueOf(responseBody.getBytes().length));
        res.getWriter().write(responseBody);
        res.getWriter().flush();
        res.getWriter().close();
    }
}

