/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import org.alfresco.repo.content.LimitedStreamCopier;
import org.alfresco.util.TempFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedHttpServletRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest request;
    private ServletInputStream providedInputStream;
    private BufferedReader providedReader;
    private File fileBody;
    private String textBody;
    private long webdavSizeLimit = -1L;
    protected Logger logger = LoggerFactory.getLogger(BufferedHttpServletRequest.class);

    public BufferedHttpServletRequest(HttpServletRequest request, long webdavSizeLimit) {
        super(request);
        this.request = request;
        this.webdavSizeLimit = webdavSizeLimit;
        this.cacheRequest();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.providedReader != null) {
            throw new IllegalStateException("Reader in use");
        }
        if (this.providedInputStream == null) {
            final FileInputStream in = new FileInputStream(this.getBufferedBodyAsFile());
            this.providedInputStream = new ServletInputStream(){

                public int read() throws IOException {
                    return in.read();
                }

                public int read(byte[] b) throws IOException {
                    return in.read(b);
                }

                public int read(byte[] b, int off, int len) throws IOException {
                    return in.read(b, off, len);
                }

                public long skip(long n) throws IOException {
                    return in.skip(n);
                }

                public int available() throws IOException {
                    return in.available();
                }

                public void close() throws IOException {
                    in.close();
                }

                public void mark(int readlimit) {
                    in.mark(readlimit);
                }

                public void reset() throws IOException {
                    in.reset();
                }

                public boolean markSupported() {
                    return in.markSupported();
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.providedInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.providedInputStream != null) {
            throw new IllegalStateException("Input Stream in use");
        }
        if (this.providedReader == null) {
            String encoding = this.request.getCharacterEncoding();
            this.providedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getBufferedBodyAsFile()), encoding == null ? "ISO-8859-1" : encoding));
        }
        return this.providedReader;
    }

    public void refresh() {
        if (this.providedInputStream != null) {
            try {
                this.providedInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.providedInputStream = null;
        }
        if (this.providedReader != null) {
            try {
                this.providedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.providedReader = null;
        }
    }

    public void cleanup() {
        if (this.fileBody != null) {
            this.fileBody.delete();
        }
    }

    private File getBufferedBodyAsFile() throws IOException {
        if (this.fileBody == null) {
            this.fileBody = TempFileProvider.createTempFile((String)"aos_request_", (String)".bin");
            LimitedStreamCopier streamCopier = new LimitedStreamCopier();
            long bytes = streamCopier.copyStreamsLong((InputStream)this.request.getInputStream(), (OutputStream)new FileOutputStream(this.fileBody), this.webdavSizeLimit);
            this.textBody = new String(Files.readAllBytes(this.fileBody.toPath()));
            long contentLength = -1L;
            try {
                contentLength = Long.valueOf(this.request.getHeader("Content-Length"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (contentLength >= 0L && contentLength != bytes) {
                throw new IOException("Request body does not have specified Content Length");
            }
        }
        return this.fileBody;
    }

    public String getBufferedBodyAsText() {
        return this.textBody;
    }

    private void cacheRequest() {
        try {
            this.getInputStream();
        }
        catch (Exception e) {
            this.logger.error("Error caching request: " + e.getMessage(), (Throwable)e);
        }
    }
}

