/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.metadata.DataModelMappingConfiguration;
import org.alfresco.module.aosmodule.metadata.OOXMLFileProcessor;
import org.alfresco.module.aosmodule.metadata.OOXMLServerPropertiesExtractionPostProcessor;
import org.alfresco.module.aosmodule.metadata.ServerPropertiesProvider;
import org.alfresco.officeservices.datamodel.ContentTypeId;
import org.alfresco.officeservices.datamodel.FieldDefinition;
import org.alfresco.officeservices.docproc.DocumentMetadataProcessor;
import org.alfresco.officeservices.docproc.DocumentProperty;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.xml.sax.SAXException;

public class OOXMLServerPropertiesExtractor
implements OOXMLFileProcessor,
InitializingBean {
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected DataModelMappingConfiguration dataModelMappingConfiguration;
    protected ServerPropertiesProvider serverPropertiesProvider;
    protected Logger logger = LoggerFactory.getLogger(OOXMLServerPropertiesExtractor.class);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"dataModelMappingConfiguration", (Object)this.dataModelMappingConfiguration);
        PropertyCheck.mandatory((Object)this, (String)"serverPropertiesProvider", (Object)this.serverPropertiesProvider);
    }

    @Override
    public boolean appliesTo(NodeRef nodeRef) {
        if (nodeRef == null) {
            return false;
        }
        QName nodeTypeQname = this.nodeService.getType(nodeRef);
        return this.dataModelMappingConfiguration.isTypeMapped(nodeTypeQname);
    }

    @Override
    public boolean appliesTo(OPCPackage pkg, NodeRef nodeRef) {
        return this.appliesTo(nodeRef) && DocumentMetadataProcessor.hasServerProperties((OPCPackage)pkg);
    }

    @Override
    public ContentFilterProcessingResult execute(OPCPackage pkg, NodeRef nodeRef) {
        if (nodeRef == null) {
            return ContentFilterProcessingResult.UNMODIFIED;
        }
        boolean isFirstVersion = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT) == null;
        Map<QName, DocumentProperty> propertyValuesBefore = null;
        if (!isFirstVersion) {
            propertyValuesBefore = this.getPropertiesMapping(nodeRef);
        }
        try {
            String contentTypeIdStr = DocumentMetadataProcessor.extractContentTypeId((OPCPackage)pkg);
            if (isFirstVersion && contentTypeIdStr != null) {
                QName newTypeName;
                ContentTypeId contentTypeId;
                block8: {
                    contentTypeId = null;
                    try {
                        contentTypeId = ContentTypeId.parse((String)contentTypeIdStr);
                    }
                    catch (ParseException pe) {
                        if (!this.logger.isDebugEnabled()) break block8;
                        this.logger.debug("Invalid ContentTypeId embedded in new Document", (Throwable)pe);
                    }
                }
                if (contentTypeId != null && (newTypeName = this.serverPropertiesProvider.getAlfrescoType(contentTypeId)) != null && this.dataModelMappingConfiguration.isInstantiable(newTypeName)) {
                    this.nodeService.setType(nodeRef, newTypeName);
                }
            }
            Map<QName, FieldDefinition> propertyMapping = this.serverPropertiesProvider.getPropertyMapping(nodeRef);
            Map propertyValuesAfter = DocumentMetadataProcessor.extractServerProperties((OPCPackage)pkg);
            String titleAfter = DocumentMetadataProcessor.extractTitle((OPCPackage)pkg);
            OOXMLServerPropertiesExtractionPostProcessor postProcessor = new OOXMLServerPropertiesExtractionPostProcessor(propertyMapping, propertyValuesBefore, propertyValuesAfter, titleAfter, this.nodeService, this.dictionaryService, this.serverPropertiesProvider);
            return new ContentFilterProcessingResult(false, postProcessor);
        }
        catch (IOException | ParserConfigurationException | OpenXML4JException | XmlException | SAXException e) {
            this.logger.error("Error extracting metadata", e);
            return ContentFilterProcessingResult.UNMODIFIED;
        }
    }

    protected Map<QName, DocumentProperty> getPropertiesMapping(NodeRef nodeRef) {
        if (this.serverPropertiesProvider != null) {
            return this.serverPropertiesProvider.getServerPropertiesMapping(nodeRef);
        }
        return null;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DataModelMappingConfiguration getDataModelMappingConfiguration() {
        return this.dataModelMappingConfiguration;
    }

    public void setDataModelMappingConfiguration(DataModelMappingConfiguration dataModelMappingConfiguration) {
        this.dataModelMappingConfiguration = dataModelMappingConfiguration;
    }

    public ServerPropertiesProvider getServerPropertiesProvider() {
        return this.serverPropertiesProvider;
    }

    public void setServerPropertiesProvider(ServerPropertiesProvider serverPropertiesProvider) {
        this.serverPropertiesProvider = serverPropertiesProvider;
    }
}

