/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.service.namespace.QName;

public class GuidHelper {
    public static String GUID_MARKER_CONTENTTYPE = "0000000000000000";
    public static String GUID_MARKER_PROPERTY = "1111111111111111";
    public static String GUID_MARKER_FILEINFOLDER = "2222222222222222";

    private GuidHelper() {
    }

    public static Guid createGuidFromStringPair(String str1, String str2, String marker) {
        if (marker.length() != 16) {
            throw new IllegalArgumentException("Invalid marker String");
        }
        Object namespaceId = Integer.toHexString(str1.hashCode()).toUpperCase();
        while (((String)namespaceId).length() < 8) {
            namespaceId = "0" + (String)namespaceId;
        }
        Object localNameId = Integer.toHexString(str2.hashCode()).toUpperCase();
        while (((String)localNameId).length() < 8) {
            localNameId = "0" + (String)localNameId;
        }
        return Guid.parse((String)((String)namespaceId + marker + (String)localNameId));
    }

    public static Guid createGuidFromQname(QName name, String marker) {
        return GuidHelper.createGuidFromStringPair(name.getNamespaceURI(), name.getLocalName(), marker);
    }

    public static boolean isGuidMarkedAs(Guid id, String marker) {
        return id.toCondensedString().substring(8, 24).equals(marker);
    }
}

