/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.auth.service;

import java.util.StringTokenizer;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AosIDSContextService {
    private static final Logger LOG = LoggerFactory.getLogger(AosIDSContextService.class);
    private static final String SUPPORTED_TYPE = "identity-service";
    private static final String PROPERTY = "chain";
    private final DefaultChildApplicationContextManager defaultChildApplicationContextManager;

    public AosIDSContextService(DefaultChildApplicationContextManager defaultChildApplicationContextManager) {
        this.defaultChildApplicationContextManager = defaultChildApplicationContextManager;
    }

    public <T> T getIdentityServiceBean(Class<T> beanClass) {
        String authId = this.fetchAuthChainName();
        Object identityServiceBean = null;
        if (authId != null) {
            try {
                identityServiceBean = this.defaultChildApplicationContextManager.getApplicationContext(authId).getBean(beanClass);
            }
            catch (Exception e) {
                LOG.warn("Error while trying to fetch IDS bean of type '{}' within auth chain: '{}' for AOS: {}", new Object[]{beanClass, authId, e.getMessage()});
            }
        }
        return (T)identityServiceBean;
    }

    private String fetchAuthChainName() {
        StringTokenizer tkn;
        String defaultChain = this.defaultChildApplicationContextManager.getProperty(PROPERTY);
        if (defaultChain != null && defaultChain.length() > 0 && (tkn = new StringTokenizer(defaultChain, ", \t\n\r\f")).hasMoreTokens()) {
            String typeName;
            String instance = tkn.nextToken();
            int sepIndex = instance.indexOf(58);
            String id = sepIndex == -1 ? instance : instance.substring(0, sepIndex);
            String string = typeName = sepIndex == -1 || sepIndex + 1 >= instance.length() ? "default" : instance.substring(sepIndex + 1);
            if (SUPPORTED_TYPE.equals(typeName)) {
                return id;
            }
        }
        return null;
    }
}

