/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.docproc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.officeservices.docproc.DocumentProperty;
import org.alfresco.officeservices.docproc.DocumentPropertyOrigin;
import org.alfresco.officeservices.docproc.OOXMLCustomPropertiesModifier;
import org.alfresco.officeservices.docproc.PropertyFormat;
import org.alfresco.officeservices.docproc.ServerMetadata;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMetadataProcessor {
    private static Logger logger = LoggerFactory.getLogger((String)"aoservices-err.DocumentPropertiesProcessor");
    public static final String TARGET_NAMESPACE = "0e656187-b300-4fb0-8bf4-3a50f872073c";
    public static final String ROOTNAMESPACE_OOXMLROPERTIES = "http://schemas.microsoft.com/office/2006/metadata/properties";
    public static final String ROOTNAMESPACE_CONTENTTYPESCHEMA = "http://schemas.microsoft.com/office/2006/metadata/contentType";
    public static final String ROOTNAMESPACE_CUSTOMXSN = "http://schemas.microsoft.com/office/2006/metadata/customXsn";
    public static final String ROOTNAMESPACE_FORMTEMPLATES = "http://schemas.microsoft.com/sharepoint/v3/contenttype/forms";
    public static final String ROOTNAMESPACE_LONGPROPERTIES = "http://schemas.microsoft.com/office/2006/metadata/longProperties";
    private static final String ITEMID_CONTENTTYPESCHEMA = "{BEF9D655-6DAB-4294-9728-317ECE650505}";
    private static final String ITEMID_FORMTEMPLATES = "{032504F6-3063-47D8-A3EF-2F93DBF9AA00}";
    private static final String ITEMID_LONGPROPERTIES = "{9A8322F7-E607-4FE3-A018-B27FCA92CAB1}";
    private static final String ITEMID_OOXMLPROPERTIES = "{CACABB1C-8557-404A-94A3-76224CD69B16}";

    private DocumentMetadataProcessor() {
    }

    public static void embedMetadata(POIFSFileSystem poiFS, ServerMetadata serverMetadata) throws IOException, HPSFException {
        DocumentSummaryInformation dsi;
        CustomProperties customProperties;
        DirectoryEntry msoDataStoreEntry;
        Boolean canReembedSharepointContentTypeDescription = true;
        Boolean hasMsoDataStore = false;
        if (poiFS.getRoot().hasEntry("PowerPoint Document")) {
            canReembedSharepointContentTypeDescription = false;
        }
        if ((msoDataStoreEntry = (DirectoryEntry)DocumentMetadataProcessor.getDataStoreEntry("MsoDataStore", poiFS)) != null) {
            hasMsoDataStore = true;
            if (canReembedSharepointContentTypeDescription.booleanValue()) {
                DocumentMetadataProcessor.removeExistingSharepointContentTypeDescription(poiFS);
                hasMsoDataStore = false;
            }
        }
        if ((customProperties = (dsi = DocumentMetadataProcessor.getDocumentSummaryInformation(poiFS)).getCustomProperties()) == null) {
            customProperties = new CustomProperties();
        } else {
            dsi.removeCustomProperties();
        }
        boolean hasServerProperties = false;
        for (DocumentProperty docProp : serverMetadata.getProperties()) {
            if (docProp.getOrigin() == DocumentPropertyOrigin.SERVER) {
                if (docProp.isReadOnly()) continue;
                hasServerProperties = true;
            }
            if (docProp.getFormattedValueString(docProp.getOrigin() == DocumentPropertyOrigin.SERVER ? PropertyFormat.OLE : PropertyFormat.XML).isEmpty()) {
                if (hasMsoDataStore.booleanValue()) continue;
                customProperties.remove((Object)docProp.getDisplayName());
                continue;
            }
            customProperties.put(docProp.getDisplayName(), (Object)docProp.getFormattedValueString(docProp.getOrigin() == DocumentPropertyOrigin.SERVER ? PropertyFormat.OLE : PropertyFormat.XML));
        }
        if (hasServerProperties || !customProperties.isEmpty()) {
            DocumentMetadataProcessor.embedSharepointContentTypeDescription(poiFS, serverMetadata, canReembedSharepointContentTypeDescription);
        }
        dsi.setCustomProperties(customProperties);
        dsi.write((DirectoryEntry)poiFS.getRoot(), "\u0005DocumentSummaryInformation");
        SummaryInformation si = DocumentMetadataProcessor.getSummaryInformation(poiFS);
        if (serverMetadata.getTitle() != null) {
            si.setTitle(serverMetadata.getTitle());
        } else {
            si.setTitle("");
        }
        si.write((DirectoryEntry)poiFS.getRoot(), "\u0005SummaryInformation");
    }

    public static void embedMetadata(OPCPackage pkg, ServerMetadata serverMetadata) throws IOException, HPSFException, OpenXML4JException, XmlException, ParserConfigurationException, SAXException {
        PackageRelationship officeDocumentRel;
        URI officeDocumentPartURI;
        POIXMLProperties props = new POIXMLProperties(pkg);
        OOXMLCustomPropertiesModifier cpm = new OOXMLCustomPropertiesModifier(props.getCustomProperties());
        boolean hasServerProperties = false;
        for (DocumentProperty docProp : serverMetadata.getProperties()) {
            if (docProp.getOrigin() == DocumentPropertyOrigin.SERVER) {
                hasServerProperties = true;
                continue;
            }
            if (docProp.getOrigin() != DocumentPropertyOrigin.CUSTOM) continue;
            cpm.setProperty(docProp.getName(), docProp.getFormattedValueString(PropertyFormat.XML));
        }
        if (serverMetadata.getTitle() != null) {
            props.getCoreProperties().setTitle(serverMetadata.getTitle());
        }
        props.commit();
        PackagePart officeDocumentPart = null;
        PackageRelationshipCollection officeDocumentCollection = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        if (officeDocumentCollection.size() == 1 && (officeDocumentPartURI = (officeDocumentRel = officeDocumentCollection.getRelationship(0)).getTargetURI()) != null) {
            PackagePartName pnOfficeDocument = PackagingURIHelper.createPartName((URI)officeDocumentPartURI);
            officeDocumentPart = pkg.getPart(pnOfficeDocument);
        }
        if (officeDocumentPart != null) {
            DocumentMetadataProcessor.removeExistingSharepointContentTypeDescription(pkg, officeDocumentPart);
            if (hasServerProperties) {
                DocumentMetadataProcessor.embedSharepointContentTypeDescription(pkg, officeDocumentPart, serverMetadata);
            }
        }
        if (hasServerProperties) {
            // empty if block
        }
    }

    public static Map<String, Object> extractServerProperties(POIFSFileSystem poiFS) throws IOException, HPSFException {
        DocumentSummaryInformation dsi = DocumentMetadataProcessor.getDocumentSummaryInformation(poiFS);
        if (dsi == null) {
            return null;
        }
        CustomProperties customProperties = dsi.getCustomProperties();
        if (customProperties == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (CustomProperty cp : customProperties.properties()) {
            result.put(cp.getName(), cp.getValue());
        }
        return result;
    }

    public static Map<String, String> extractServerProperties(OPCPackage pkg) throws InvalidFormatException, ParserConfigurationException, SAXException, IOException {
        Document xmlDocument = DocumentMetadataProcessor.findCustomXmlDocumentByRootNamespace(pkg, ROOTNAMESPACE_OOXMLROPERTIES);
        if (xmlDocument == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Element rootElement = xmlDocument.getDocumentElement();
        NodeList dmNodes = rootElement.getElementsByTagName("documentManagement");
        if (dmNodes.getLength() > 0) {
            Element dmElement = (Element)dmNodes.item(0);
            NodeList propElementsList = dmElement.getChildNodes();
            for (int pi = 0; pi < propElementsList.getLength(); ++pi) {
                Node childNode;
                Element propertyElement;
                Node n = propElementsList.item(pi);
                if (!(n instanceof Element) || null == (propertyElement = (Element)n) || null == (childNode = propertyElement.getFirstChild())) continue;
                String t = childNode.getNodeValue();
                result.put(propertyElement.getNodeName(), t);
            }
        }
        return result;
    }

    public static String extractTitle(POIFSFileSystem poiFS) throws IOException, HPSFException {
        return DocumentMetadataProcessor.getSummaryInformation(poiFS).getTitle();
    }

    public static String extractTitle(OPCPackage pkg) throws IOException, OpenXML4JException, XmlException {
        POIXMLProperties props = new POIXMLProperties(pkg);
        return props.getCoreProperties().getTitle();
    }

    public static String extractContentTypeId(POIFSFileSystem poiFS) throws IOException, HPSFException {
        DocumentSummaryInformation dsi = DocumentMetadataProcessor.getDocumentSummaryInformation(poiFS);
        if (dsi == null) {
            return null;
        }
        CustomProperties customProperties = dsi.getCustomProperties();
        if (customProperties == null) {
            return null;
        }
        Object contentTypeIdValue = customProperties.get((Object)"ContentTypeId");
        if (contentTypeIdValue instanceof String) {
            return (String)contentTypeIdValue;
        }
        return null;
    }

    public static String extractContentTypeId(OPCPackage pkg) throws InvalidFormatException, ParserConfigurationException, SAXException, IOException {
        Document xmlDocument = DocumentMetadataProcessor.findCustomXmlDocumentByRootNamespace(pkg, ROOTNAMESPACE_CONTENTTYPESCHEMA);
        if (xmlDocument == null) {
            return null;
        }
        Element rootElement = xmlDocument.getDocumentElement();
        if (rootElement.getNodeName().equals("ct:contentTypeSchema")) {
            return rootElement.getAttribute("ma:contentTypeID");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentSummaryInformation getDocumentSummaryInformation(POIFSFileSystem poiFS) throws IOException, HPSFException {
        Entry dsiEntry = DocumentMetadataProcessor.getDataStoreEntry("\u0005DocumentSummaryInformation", poiFS);
        if (!dsiEntry.isDocumentEntry()) {
            throw new FileNotFoundException("not a document stream: \"\u0005DocumentSummaryInformation\"");
        }
        DocumentInputStream in = new DocumentInputStream((DocumentEntry)dsiEntry);
        try {
            DocumentSummaryInformation documentSummaryInformation = new DocumentSummaryInformation(new PropertySet((InputStream)in));
            return documentSummaryInformation;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SummaryInformation getSummaryInformation(POIFSFileSystem poiFS) throws IOException, HPSFException {
        Entry siEntry = DocumentMetadataProcessor.getDataStoreEntry("\u0005SummaryInformation", poiFS);
        if (!siEntry.isDocumentEntry()) {
            throw new FileNotFoundException("not a document stream: \"\u0005SummaryInformation\"");
        }
        DocumentInputStream in = new DocumentInputStream((DocumentEntry)siEntry);
        try {
            SummaryInformation summaryInformation = new SummaryInformation(new PropertySet((InputStream)in));
            return summaryInformation;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    private static void embedSharepointContentTypeDescription(POIFSFileSystem poiFS, ServerMetadata serverMetadata, boolean reembedable) throws IOException, HPSFException {
        DirectoryEntry msoDataStoreEntry = (DirectoryEntry)DocumentMetadataProcessor.getDataStoreEntry("MsoDataStore", poiFS);
        if (msoDataStoreEntry == null) {
            msoDataStoreEntry = poiFS.getRoot().createDirectory("MsoDataStore");
        } else if (!reembedable) {
            return;
        }
        DirectoryEntry contentTypeSchemaDataStore = DocumentMetadataProcessor.createNewDataStore(msoDataStoreEntry);
        contentTypeSchemaDataStore.createDocument("Item", DocumentMetadataProcessor.generateContentTypeSchema_Item(serverMetadata, TargetFileFormat.OLE));
        contentTypeSchemaDataStore.createDocument("Properties", DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_CONTENTTYPESCHEMA));
        DirectoryEntry formTemplatesDataStore = DocumentMetadataProcessor.createNewDataStore(msoDataStoreEntry);
        formTemplatesDataStore.createDocument("Item", DocumentMetadataProcessor.generateFormTemplates_Item(serverMetadata));
        formTemplatesDataStore.createDocument("Properties", DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_FORMTEMPLATES));
        DirectoryEntry longPropertiesDataStore = DocumentMetadataProcessor.createNewDataStore(msoDataStoreEntry);
        longPropertiesDataStore.createDocument("Item", DocumentMetadataProcessor.generateLongProperties_Item(serverMetadata));
        longPropertiesDataStore.createDocument("Properties", DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_LONGPROPERTIES));
    }

    private static void embedSharepointContentTypeDescription(OPCPackage pkg, PackagePart mainPart, ServerMetadata serverMetadata) throws IOException, HPSFException, OpenXML4JException, XmlException {
        DocumentMetadataProcessor.addCustomXml(pkg, mainPart, DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_CONTENTTYPESCHEMA), DocumentMetadataProcessor.generateContentTypeSchema_Item(serverMetadata, TargetFileFormat.OOXML));
        DocumentMetadataProcessor.addCustomXml(pkg, mainPart, DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_FORMTEMPLATES), DocumentMetadataProcessor.generateFormTemplates_Item(serverMetadata));
        DocumentMetadataProcessor.addCustomXml(pkg, mainPart, DocumentMetadataProcessor.generateDataStoreProperties(ITEMID_OOXMLPROPERTIES), DocumentMetadataProcessor.generateOOXMLProperties_Item(serverMetadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeExistingSharepointContentTypeDescription(POIFSFileSystem poiFS) {
        DirectoryEntry dir;
        DirectoryEntry msoDataStoreEntry = (DirectoryEntry)DocumentMetadataProcessor.getDataStoreEntry("MsoDataStore", poiFS);
        if (msoDataStoreEntry == null) {
            return;
        }
        Iterator itEntries = msoDataStoreEntry.getEntries();
        ArrayList<DirectoryEntry> directoriesToDelete = new ArrayList<DirectoryEntry>();
        while (itEntries.hasNext()) {
            Entry e = (Entry)itEntries.next();
            if (!(e instanceof DirectoryEntry)) continue;
            dir = (DirectoryEntry)e;
            Entry itemEntry = null;
            try {
                itemEntry = dir.getEntry("Item");
                if (!(itemEntry instanceof DocumentEntry)) continue;
                DocumentEntry itemDocument = (DocumentEntry)itemEntry;
                String rootNamespace = null;
                try (DocumentInputStream in = new DocumentInputStream(itemDocument);){
                    rootNamespace = DocumentMetadataProcessor.getRootNamespace((InputStream)in);
                }
                if (rootNamespace == null || !rootNamespace.equalsIgnoreCase(ROOTNAMESPACE_CONTENTTYPESCHEMA) && !rootNamespace.equalsIgnoreCase(ROOTNAMESPACE_FORMTEMPLATES) && !rootNamespace.equalsIgnoreCase(ROOTNAMESPACE_LONGPROPERTIES) && !rootNamespace.equalsIgnoreCase(ROOTNAMESPACE_CUSTOMXSN)) continue;
                directoriesToDelete.add(dir);
            }
            catch (Exception ex) {}
        }
        for (int i = 0; i < directoriesToDelete.size(); ++i) {
            try {
                dir = (DirectoryEntry)directoriesToDelete.get(i);
                dir.getEntry("Item").delete();
                dir.getEntry("Properties").delete();
                dir.delete();
                continue;
            }
            catch (Exception e) {
                logger.error("removeExistingSharepointContentTypeDescription: Error removing extension container from MsoDataStore", (Throwable)e);
            }
        }
    }

    private static void removeExistingSharepointContentTypeDescription(OPCPackage pkg, PackagePart mainPart) throws InvalidFormatException, IOException, ParserConfigurationException, SAXException {
        for (PackagePart part : pkg.getParts()) {
            String partName = part.getPartName().getName();
            if (!partName.startsWith("/customXml/item") || !partName.endsWith(".xml") || !part.getContentType().equals("application/xml")) continue;
            InputStream inPart = part.getInputStream();
            String rootNamespace = DocumentMetadataProcessor.getRootNamespace(inPart);
            inPart.close();
            if (!rootNamespace.equals(ROOTNAMESPACE_CONTENTTYPESCHEMA) && !rootNamespace.equals(ROOTNAMESPACE_FORMTEMPLATES) && !rootNamespace.equals(ROOTNAMESPACE_OOXMLROPERTIES) && !rootNamespace.equals(ROOTNAMESPACE_CUSTOMXSN)) continue;
            PackageRelationshipCollection prc = mainPart.getRelationships();
            for (PackageRelationship pr : prc) {
                URI partURI;
                URI targetURI = pr.getTargetURI();
                if (!targetURI.equals(partURI = part.getPartName().getURI())) continue;
                mainPart.removeRelationship(pr.getId());
            }
            pkg.removePartRecursive(part.getPartName());
        }
    }

    public static boolean hasServerProperties(OPCPackage pkg) {
        try {
            return DocumentMetadataProcessor.findCustomXmlDocumentByRootNamespace(pkg, ROOTNAMESPACE_OOXMLROPERTIES) != null;
        }
        catch (IOException | ParserConfigurationException | InvalidFormatException | SAXException e) {
            logger.error("Error finding customXML document by root namespace.", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasServerProperties(POIFSFileSystem poiFS) {
        DirectoryEntry msoDataStoreEntry = (DirectoryEntry)DocumentMetadataProcessor.getDataStoreEntry("MsoDataStore", poiFS);
        if (msoDataStoreEntry == null) {
            return false;
        }
        Iterator itEntries = msoDataStoreEntry.getEntries();
        while (itEntries.hasNext()) {
            Entry e = (Entry)itEntries.next();
            if (!(e instanceof DirectoryEntry)) continue;
            DirectoryEntry dir = (DirectoryEntry)e;
            Entry itemEntry = null;
            try {
                itemEntry = dir.getEntry("Item");
                if (!(itemEntry instanceof DocumentEntry)) continue;
                DocumentEntry itemDocument = (DocumentEntry)itemEntry;
                String rootNamespace = null;
                try (DocumentInputStream in = new DocumentInputStream(itemDocument);){
                    rootNamespace = DocumentMetadataProcessor.getRootNamespace((InputStream)in);
                }
                if (rootNamespace == null || !rootNamespace.equalsIgnoreCase(ROOTNAMESPACE_CONTENTTYPESCHEMA)) continue;
                return true;
            }
            catch (Exception ex) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document findCustomXmlDocumentByRootNamespace(OPCPackage pkg, String rootNamespace) throws ParserConfigurationException, SAXException, IOException, InvalidFormatException {
        for (PackagePart part : pkg.getParts()) {
            String partName = part.getPartName().getName();
            if (!partName.startsWith("/customXml/item") || !partName.endsWith(".xml") || !part.getContentType().equals("application/xml")) continue;
            try (InputStream inPart = part.getInputStream();){
                Document xmlDocument = DocumentMetadataProcessor.getDocumentFromStream(inPart);
                String rns = DocumentMetadataProcessor.getRootNamespace(xmlDocument);
                if (!rootNamespace.equals(rns)) continue;
                Document document = xmlDocument;
                return document;
            }
        }
        return null;
    }

    private static String getRootNamespace(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        Document xmlDocument = DocumentMetadataProcessor.getDocumentFromStream(in);
        return xmlDocument == null ? null : DocumentMetadataProcessor.getRootNamespace(xmlDocument);
    }

    private static String getRootNamespace(Document xmlDocument) {
        Element rootElement = xmlDocument.getDocumentElement();
        String rootElementName = rootElement.getNodeName();
        String rootElementPrefix = null;
        if (rootElementName.indexOf(58) >= 0) {
            rootElementPrefix = rootElementName.substring(0, rootElementName.indexOf(58));
        }
        if (rootElementPrefix == null) {
            return rootElement.getAttribute("xmlns");
        }
        return rootElement.getAttribute("xmlns:" + rootElementPrefix);
    }

    private static Document getDocumentFromStream(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return docBuilder.parse(in);
    }

    private static String generateRandomDataStoreName() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 22; ++i) {
            int rand = (int)(Math.random() * 36.0);
            if (rand <= 9) {
                result.append(48 + (char)rand);
                continue;
            }
            result.append(65 + (char)(rand - 10));
        }
        result.append("==");
        return result.toString();
    }

    private static DirectoryEntry createNewDataStore(DirectoryEntry msoDataStoreEntry) throws IOException {
        int max = 0;
        while (max++ < 100) {
            String potentialName = DocumentMetadataProcessor.generateRandomDataStoreName();
            if (msoDataStoreEntry.hasEntry(potentialName)) continue;
            return msoDataStoreEntry.createDirectory(potentialName);
        }
        throw new IOException("Cannot find free DataStoreName");
    }

    private static Entry getDataStoreEntry(String name, POIFSFileSystem poiFS) {
        Entry msoDataStoreEntry = null;
        if (poiFS.getRoot().hasEntry(name)) {
            try {
                msoDataStoreEntry = poiFS.getRoot().getEntry(name);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return msoDataStoreEntry;
    }

    private static String htmlEncode(String s) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&#39;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private static void addCustomXml(OPCPackage pkg, PackagePart mainPart, InputStream inProperties, InputStream inItem) throws IOException, OpenXML4JException, XmlException {
        int i;
        int nextFreeItemId = DocumentMetadataProcessor.findFreeCustomXmlNbr(pkg);
        String propsName = "itemProps" + nextFreeItemId + ".xml";
        String itemName = "item" + nextFreeItemId + ".xml";
        PackagePartName pnProps = PackagingURIHelper.createPartName((String)("/customXml/" + propsName));
        PackagePart propsPart = pkg.createPart(pnProps, "application/vnd.openxmlformats-officedocument.customXmlProperties+xml");
        OutputStream partPropsOut = propsPart.getOutputStream();
        while ((i = inProperties.read()) > 0) {
            partPropsOut.write(i);
        }
        partPropsOut.close();
        PackagePartName pnItem = PackagingURIHelper.createPartName((String)("/customXml/" + itemName));
        PackagePart itemPart = pkg.createPart(pnItem, "application/xml");
        OutputStream partItemOut = itemPart.getOutputStream();
        while ((i = inItem.read()) > 0) {
            partItemOut.write(i);
        }
        partItemOut.close();
        itemPart.addRelationship(pnProps, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps");
        mainPart.addRelationship(pnItem, TargetMode.INTERNAL, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml");
    }

    protected static int findFreeCustomXmlNbr(OPCPackage pkg) {
        int test = 1;
        boolean found = false;
        while (!found && test < 1000) {
            try {
                PackagePartName pnTest = PackagingURIHelper.createPartName((String)("/customXml/item" + test + ".xml"));
                if (pkg.getPart(pnTest) == null) {
                    found = true;
                    continue;
                }
                ++test;
            }
            catch (Exception e) {
                found = true;
            }
        }
        return test;
    }

    private static InputStream generateDataStoreProperties(String itemId) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
        ps.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        ps.println("<ds:datastoreItem ds:itemID=\"");
        ps.print(DocumentMetadataProcessor.htmlEncode(itemId));
        ps.print("\" xmlns:ds=\"http://schemas.openxmlformats.org/officeDocument/2006/customXml\"/>");
        ps.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private static InputStream generateContentTypeSchema_Item(ServerMetadata serverMetadata, TargetFileFormat targetFileFormat) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
        ps.println("<?xml version=\"1.0\" encoding=\"utf-8\"?><ct:contentTypeSchema ct:_=\"\" ma:_=\"\" ma:contentTypeName=\"" + DocumentMetadataProcessor.htmlEncode(serverMetadata.getContentTypeName()) + "\" ma:contentTypeID=\"" + DocumentMetadataProcessor.htmlEncode(serverMetadata.getContentTypeId()) + "\" ma:contentTypeVersion=\"1\" ma:contentTypeDescription=\"\" ma:contentTypeScope=\"\" ma:versionID=\"84a7f6b9a9324c93f7c429fe637c4145\" xmlns:ct=\"http://schemas.microsoft.com/office/2006/metadata/contentType\" xmlns:ma=\"http://schemas.microsoft.com/office/2006/metadata/properties/metaAttributes\">");
        ps.println("<xsd:schema targetNamespace=\"http://schemas.microsoft.com/office/2006/metadata/properties\" ma:root=\"true\" ma:fieldsID=\"d82bb511108d8e269345fc9bd5c1ab5b\" ns2:_=\"\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:p=\"http://schemas.microsoft.com/office/2006/metadata/properties\" xmlns:ns2=\"0e656187-b300-4fb0-8bf4-3a50f872073c\">");
        ps.println("<xsd:import namespace=\"0e656187-b300-4fb0-8bf4-3a50f872073c\"/>");
        ps.println("<xsd:element name=\"properties\">");
        ps.println("<xsd:complexType>");
        ps.println("<xsd:sequence>");
        ps.println("<xsd:element name=\"documentManagement\">");
        ps.println("<xsd:complexType>");
        ps.println("<xsd:all>");
        for (DocumentProperty documentProperty : serverMetadata.getProperties()) {
            if (documentProperty.getOrigin() != DocumentPropertyOrigin.SERVER || targetFileFormat != TargetFileFormat.OOXML && documentProperty.isReadOnly()) continue;
            ps.println("<xsd:element ref=\"ns2:" + documentProperty.getName() + "\"" + (documentProperty.isMandatory() ? "" : " minOccurs=\"0\"") + "/>");
        }
        ps.println("</xsd:all>");
        ps.println("</xsd:complexType>");
        ps.println("</xsd:element>");
        ps.println("</xsd:sequence>");
        ps.println("</xsd:complexType>");
        ps.println("</xsd:element>");
        ps.println("</xsd:schema>");
        ps.println("<xsd:schema targetNamespace=\"0e656187-b300-4fb0-8bf4-3a50f872073c\" elementFormDefault=\"qualified\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:dms=\"http://schemas.microsoft.com/office/2006/documentManagement/types\">");
        ps.println("<xsd:import namespace=\"http://schemas.microsoft.com/office/2006/documentManagement/types\"/>");
        int uniqueIndexCnt = 8;
        for (DocumentProperty docProp : serverMetadata.getProperties()) {
            if (docProp.getOrigin() != DocumentPropertyOrigin.SERVER || targetFileFormat != TargetFileFormat.OOXML && docProp.isReadOnly()) continue;
            String name = docProp.getName();
            String encodedOfficeDisplayName = DocumentMetadataProcessor.htmlEncode(docProp.getDisplayName());
            boolean readOnly = docProp.isReadOnly();
            switch (docProp.getDataType()) {
                case TEXT: {
                    ps.println("<xsd:element name=\"" + name + "\" " + (readOnly ? "ma:readOnly=\"true\" " : "") + "ma:index=\"" + Integer.toString(uniqueIndexCnt++) + "\" " + (docProp.isMandatory() ? "" : "nillable=\"true\" ") + "ma:displayName=\"" + encodedOfficeDisplayName + "\" ma:internalName=\"" + name + "\">");
                    ps.println("<xsd:simpleType>");
                    ps.println("<xsd:restriction base=\"" + (docProp.isMultilineText() ? "dms:Note" : "dms:Text") + "\">");
                    if (docProp.getMinTextLength() != null) {
                        ps.print("<xsd:minLength value=\"");
                        ps.print(docProp.getMinTextLength());
                        ps.println("\"/>");
                    }
                    if (docProp.getMaxTextLength() != null) {
                        ps.print("<xsd:maxLength value=\"");
                        ps.print(docProp.getMaxTextLength());
                        ps.println("\"/>");
                    }
                    ps.println("</xsd:restriction>");
                    ps.println("</xsd:simpleType>");
                    ps.println("</xsd:element>");
                    break;
                }
                case CHOICE: {
                    ps.println("<xsd:element name=\"" + name + "\" " + (readOnly ? "ma:readOnly=\"true\" " : "") + "ma:index=\"" + Integer.toString(uniqueIndexCnt++) + "\" " + (docProp.isMandatory() ? "" : "nillable=\"true\" ") + "ma:displayName=\"" + encodedOfficeDisplayName + "\" ma:format=\"Dropdown\" ma:internalName=\"" + name + "\">");
                    ps.println("<xsd:simpleType>");
                    ps.println("<xsd:restriction base=\"dms:Choice\">");
                    if (docProp.getChoices() != null) {
                        for (String choice : docProp.getChoices()) {
                            ps.print("<xsd:enumeration value=\"");
                            ps.print(DocumentMetadataProcessor.htmlEncode(choice));
                            ps.println("\"/>");
                        }
                    }
                    ps.println("</xsd:restriction>");
                    ps.println("</xsd:simpleType>");
                    ps.println("</xsd:element>");
                    break;
                }
                case NUMBER: {
                    ps.println("<xsd:element name=\"" + name + "\" " + (readOnly ? "ma:readOnly=\"true\" " : "") + "ma:index=\"" + Integer.toString(uniqueIndexCnt++) + "\" " + (docProp.isMandatory() ? "" : "nillable=\"true\" ") + "ma:displayName=\"" + encodedOfficeDisplayName + "\" ma:decimals=\"" + Integer.toString(Math.max(0, docProp.getDecimals())) + "\" ma:internalName=\"" + name + "\">");
                    ps.println("<xsd:simpleType>");
                    ps.println("<xsd:restriction base=\"dms:Number\">");
                    if (docProp.getMinValue() != null) {
                        ps.print("<xsd:minInclusive value=\"");
                        ps.print(docProp.getFormattedMinValueString());
                        ps.println("\"/>");
                    }
                    if (docProp.getMaxValue() != null) {
                        ps.print("<xsd:maxInclusive value=\"");
                        ps.print(docProp.getFormattedMaxValueString());
                        ps.println("\"/>");
                    }
                    ps.println("</xsd:restriction>");
                    ps.println("</xsd:simpleType>");
                    ps.println("</xsd:element>");
                    break;
                }
                case DATETIME: {
                    ps.println("<xsd:element name=\"" + name + "\" " + (readOnly ? "ma:readOnly=\"true\" " : "") + "ma:index=\"" + Integer.toString(uniqueIndexCnt++) + "\" " + (docProp.isMandatory() ? "" : "nillable=\"true\" ") + "ma:displayName=\"" + encodedOfficeDisplayName + "\" ma:format=\"" + docProp.getDateFormat().getFormatIdentifier() + "\" ma:internalName=\"" + name + "\">");
                    ps.println("<xsd:simpleType>");
                    ps.println("<xsd:restriction base=\"dms:DateTime\">");
                    ps.println("</xsd:restriction>");
                    ps.println("</xsd:simpleType>");
                    ps.println("</xsd:element>");
                    break;
                }
                case BOOLEAN: {
                    ps.println("<xsd:element name=\"" + name + "\" " + (readOnly ? "ma:readOnly=\"true\" " : "") + "ma:index=\"" + Integer.toString(uniqueIndexCnt++) + "\" " + (docProp.isMandatory() ? "" : "nillable=\"true\" ") + "ma:displayName=\"" + encodedOfficeDisplayName + "\" ma:default=\"0\" ma:internalName=\"" + name + "\">");
                    ps.println("<xsd:simpleType>");
                    ps.println("<xsd:restriction base=\"dms:Boolean\">");
                    ps.println("</xsd:restriction>");
                    ps.println("</xsd:simpleType>");
                    ps.println("</xsd:element>");
                    break;
                }
            }
        }
        ps.println("</xsd:schema>");
        ps.println("<xsd:schema targetNamespace=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" elementFormDefault=\"qualified\" attributeFormDefault=\"unqualified\" blockDefault=\"#all\" xmlns=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:odoc=\"http://schemas.microsoft.com/office/internal/2005/internalDocumentation\">");
        ps.println("<xsd:import namespace=\"http://purl.org/dc/elements/1.1/\" schemaLocation=\"http://dublincore.org/schemas/xmls/qdc/2003/04/02/dc.xsd\"/>");
        ps.println("<xsd:import namespace=\"http://purl.org/dc/terms/\" schemaLocation=\"http://dublincore.org/schemas/xmls/qdc/2003/04/02/dcterms.xsd\"/>");
        ps.println("<xsd:element name=\"coreProperties\" type=\"CT_coreProperties\"/>");
        ps.println("<xsd:complexType name=\"CT_coreProperties\">");
        ps.println("<xsd:all>");
        ps.println("<xsd:element ref=\"dc:creator\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element ref=\"dcterms:created\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element ref=\"dc:identifier\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element name=\"contentType\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\" ma:index=\"0\" ma:displayName=\"Content-Type\" ma:readOnly=\"true\"/>");
        ps.println("<xsd:element ref=\"dc:title\" minOccurs=\"0\" maxOccurs=\"1\" ma:index=\"4\" ma:displayName=\"Title\"/>");
        ps.println("<xsd:element ref=\"dc:subject\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element ref=\"dc:description\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element name=\"keywords\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\"/>");
        ps.println("<xsd:element ref=\"dc:language\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element name=\"category\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\"/>");
        ps.println("<xsd:element name=\"version\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\"/>");
        ps.println("<xsd:element name=\"revision\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\">");
        ps.println("<xsd:annotation>");
        ps.println("<xsd:documentation></xsd:documentation>");
        ps.println("</xsd:annotation>");
        ps.println("</xsd:element>");
        ps.println("<xsd:element name=\"lastModifiedBy\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\"/>");
        ps.println("<xsd:element ref=\"dcterms:modified\" minOccurs=\"0\" maxOccurs=\"1\"/>");
        ps.println("<xsd:element name=\"lastPrinted\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:dateTime\"/>");
        ps.println("<xsd:element name=\"contentStatus\" minOccurs=\"0\" maxOccurs=\"1\" type=\"xsd:string\"/>");
        ps.println("</xsd:all>");
        ps.println("</xsd:complexType>");
        ps.println("</xsd:schema>");
        ps.print("</ct:contentTypeSchema>");
        ps.close();
        bos.close();
        byte[] byArray = bos.toByteArray();
        return new ByteArrayInputStream(byArray);
    }

    private static InputStream generateFormTemplates_Item(ServerMetadata serverMetadata) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
        ps.println("<?mso-contentType?><FormTemplates xmlns=\"http://schemas.microsoft.com/sharepoint/v3/contenttype/forms\"><Display>DocumentLibraryForm</Display><Edit>DocumentLibraryForm</Edit><New>DocumentLibraryForm</New></FormTemplates>");
        ps.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private static InputStream generateLongProperties_Item(ServerMetadata serverMetadata) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
        ps.println("<?xml version=\"1.0\" encoding=\"utf-8\"?><LongProperties xmlns=\"http://schemas.microsoft.com/office/2006/metadata/longProperties\"/>");
        ps.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private static InputStream generateOOXMLProperties_Item(ServerMetadata serverMetadata) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream((OutputStream)bos, false, "UTF-8");
        ps.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        ps.print("<p:properties xmlns:p=\"http://schemas.microsoft.com/office/2006/metadata/properties\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:pc=\"http://schemas.microsoft.com/office/infopath/2007/PartnerControls\">");
        ps.print("<documentManagement>");
        for (DocumentProperty docProp : serverMetadata.getProperties()) {
            if (docProp.getOrigin() != DocumentPropertyOrigin.SERVER) continue;
            if (docProp.getValue() == null) {
                ps.print("<" + docProp.getName() + "  xmlns=\"0e656187-b300-4fb0-8bf4-3a50f872073c\"" + (docProp.isMandatory() ? "" : " xsi:nil=\"true\"") + "/>");
                continue;
            }
            String propertyText = DocumentMetadataProcessor.htmlEncode(docProp.getFormattedValueString(PropertyFormat.XML));
            if (propertyText.length() == 0) {
                ps.print("<" + docProp.getName() + "  xmlns=\"0e656187-b300-4fb0-8bf4-3a50f872073c\"" + (docProp.isMandatory() ? "" : " xsi:nil=\"true\"") + "/>");
                continue;
            }
            ps.print("<" + docProp.getName() + "  xmlns=\"0e656187-b300-4fb0-8bf4-3a50f872073c\">");
            ps.print(propertyText);
            ps.print("</" + docProp.getName() + ">");
        }
        ps.print("</documentManagement>");
        ps.print("</p:properties>");
        ps.close();
        bos.close();
        byte[] data = bos.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private static enum TargetFileFormat {
        OLE,
        OOXML;

    }
}

