/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.alfresco.module.aosmodule.service.ServiceFilter;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServerRootResponder
extends HttpServlet {
    private static final long serialVersionUID = 4207220180323049L;
    protected AuthenticationService authenticationService;
    private AlfrescoVirtualFileSystem vfs;
    protected Logger logger = LoggerFactory.getLogger(ServerRootResponder.class);

    public void init() throws ServletException {
        super.init();
        this.logger.debug("ServerRootResponder.init");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (context == null) {
            return;
        }
        ServiceRegistry serviceRegistry = (ServiceRegistry)context.getBean("ServiceRegistry");
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.vfs = (AlfrescoVirtualFileSystem)context.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        this.vfs.prepare();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.debug("ServerRootResponder.service METHOD=" + request.getMethod());
        if (request.getMethod().equals("PROPFIND")) {
            this.doPropfind(request, response);
        } else {
            super.service(request, response);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentUser = null;
        try {
            currentUser = this.authenticationService.getCurrentUserName();
        }
        catch (Exception e) {
            currentUser = "NOT_AUTHENTICATED";
        }
        this.logger.debug("ServerRootResponder.doOptions authUser=" + currentUser);
        ServiceFilter.appendResponseHeaders(response);
        response.setStatus(200);
    }

    protected void doPropfind(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String currentUser = null;
        try {
            currentUser = this.authenticationService.getCurrentUserName();
        }
        catch (Exception e) {
            currentUser = "NOT_AUTHENTICATED";
        }
        this.logger.debug("ServerRootResponder.doPropfind authUser=" + currentUser);
        ServiceFilter.appendResponseHeaders(response);
        response.setStatus(207);
        int depth = 0;
        String depthHeaderParameter = request.getHeader("Depth");
        if (depthHeaderParameter != null) {
            try {
                depth = Integer.parseInt(depthHeaderParameter);
                if (depth < 0) {
                    depth = 0;
                }
                if (depth > 1) {
                    depth = 1;
                }
            }
            catch (NumberFormatException nfe) {
                depth = 0;
            }
        }
        String serverUrl = this.vfs.getServerRootUrl(request);
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        response.setStatus(207);
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        out.println("<D:multistatus xmlns:D=\"DAV:\" xmlns:Office=\"urn:schemas-microsoft-com:office:office\" xmlns:Repl=\"http://schemas.microsoft.com/repl/\" xmlns:Z=\"urn:schemas-microsoft-com:\">");
        out.println("  <D:response>");
        out.println("    <D:href>" + serverUrl + "</D:href>");
        out.println("    <D:propstat>");
        out.println("      <D:prop>");
        out.println("        <D:displayname></D:displayname>");
        out.println("        <D:lockdiscovery/>");
        out.println("        <D:supportedlock/>");
        out.println("        <D:isFolder>t</D:isFolder>");
        out.println("        <D:iscollection>1</D:iscollection>");
        out.println("        <D:ishidden>0</D:ishidden>");
        out.println("        <D:getcontenttype>application/octet-stream</D:getcontenttype>");
        out.println("        <D:getcontentlength>0</D:getcontentlength>");
        out.println("        <D:resourcetype><D:collection/></D:resourcetype>");
        out.println("        <Repl:authoritative-directory>t</Repl:authoritative-directory>");
        out.println("        <D:getlastmodified>2009-04-03T12:48:40Z</D:getlastmodified>");
        out.println("        <D:creationdate>2009-04-03T12:48:40Z</D:creationdate>");
        out.println("        <Repl:repl-uid>rid:{5A000D79-1C51-41AE-9953-62BF3AA27C79}</Repl:repl-uid>");
        out.println("        <Repl:resourcetag>rt:5A000D79-1C51-41AE-9953-62BF3AA27C79@00000000000</Repl:resourcetag>");
        out.println("        <D:getetag>&quot;{5A000D79-1C51-41AE-9953-62BF3AA27C79},0&quot;</D:getetag>");
        out.println("      </D:prop>");
        out.println("      <D:status>HTTP/1.1 200 OK</D:status>");
        out.println("    </D:propstat>");
        out.println("  </D:response>");
        if (depth > 0) {
            out.println("  <D:response>");
            out.println("    <D:href>" + serverUrl + request.getContextPath() + "</D:href>");
            out.println("    <D:propstat>");
            out.println("      <D:prop>");
            out.println("        <D:displayname></D:displayname>");
            out.println("        <D:lockdiscovery/>");
            out.println("        <D:supportedlock/>");
            out.println("        <D:isFolder>t</D:isFolder>");
            out.println("        <D:iscollection>1</D:iscollection>");
            out.println("        <D:ishidden>0</D:ishidden>");
            out.println("        <D:getcontenttype>application/octet-stream</D:getcontenttype>");
            out.println("        <D:getcontentlength>0</D:getcontentlength>");
            out.println("        <D:resourcetype><D:collection/></D:resourcetype>");
            out.println("        <Repl:authoritative-directory>t</Repl:authoritative-directory>");
            out.println("        <D:getlastmodified>2009-04-03T12:47:48Z</D:getlastmodified>");
            out.println("        <D:creationdate>2009-04-03T12:43:12Z</D:creationdate>");
            out.println("        <Repl:repl-uid>rid:{5A000D79-1C51-41AE-9953-62BF3AA27C79}</Repl:repl-uid>");
            out.println("        <Repl:resourcetag>rt:5A000D79-1C51-41AE-9953-62BF3AA27C79@00000000000</Repl:resourcetag>");
            out.println("        <D:getetag>&quot;{5A000D79-1C51-41AE-9953-62BF3AA27C79},0&quot;</D:getetag>");
            out.println("      </D:prop>");
            out.println("      <D:status>HTTP/1.1 200 OK</D:status>");
            out.println("    </D:propstat>");
            out.println("  </D:response>");
        }
        out.println("</D:multistatus>");
    }
}

