/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.List;
import org.alfresco.module.aosmodule.metadata.AbstractContentFilter;
import org.alfresco.module.aosmodule.metadata.ChainingContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.metadata.ContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.OOXMLFileProcessor;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.poi.EmptyFileException;
import org.apache.poi.ooxml.util.PackageHelper;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.util.IOUtils;

public class OOXMLFileContentFilter
extends AbstractContentFilter {
    List<OOXMLFileProcessor> processors = null;

    public List<OOXMLFileProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<OOXMLFileProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public int getMaxInputPreviewByteCount() {
        return 4;
    }

    @Override
    public boolean appliesToInput(String mimeType, PushbackInputStream pis, NodeRef nodeRef) throws IOException {
        if (this.processors == null || this.processors.size() == 0) {
            return false;
        }
        if (!super.appliesToInput(mimeType, pis, nodeRef)) {
            return false;
        }
        try {
            if (FileMagic.valueOf((byte[])IOUtils.peekFirst8Bytes((InputStream)pis)) != FileMagic.OOXML) {
                return false;
            }
        }
        catch (EmptyFileException efe) {
            return false;
        }
        for (OOXMLFileProcessor processor : this.processors) {
            if (!processor.appliesTo(nodeRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean appliesToOutput(NodeRef nodeRef, ContentReader contentReader) {
        if (!super.appliesToOutput(nodeRef, contentReader)) {
            return false;
        }
        if (this.processors == null || this.processors.size() == 0) {
            return false;
        }
        for (OOXMLFileProcessor processor : this.processors) {
            if (!processor.appliesTo(nodeRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContentFilterProcessingResult process(NodeRef nodeRef, InputStream in, OutputStream out, boolean stopOnNoOp) throws IOException {
        if (this.processors == null || this.processors.size() == 0) {
            if (stopOnNoOp || out == null) {
                return ContentFilterProcessingResult.UNMODIFIED;
            }
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)out);
            return ContentFilterProcessingResult.MODIFIED;
        }
        OPCPackage pkg = PackageHelper.open((InputStream)in);
        boolean haveInterestedProcessors = false;
        for (OOXMLFileProcessor processor : this.processors) {
            haveInterestedProcessors |= processor.appliesTo(pkg, nodeRef);
        }
        if (!haveInterestedProcessors) {
            if (stopOnNoOp || out == null) {
                return ContentFilterProcessingResult.UNMODIFIED;
            }
            pkg.save(out);
            return ContentFilterProcessingResult.MODIFIED;
        }
        boolean hasModifications = false;
        ContentPostProcessor postProcessor = null;
        for (OOXMLFileProcessor processor : this.processors) {
            if (!processor.appliesTo(pkg, nodeRef)) continue;
            ContentFilterProcessingResult processorResult = processor.execute(pkg, nodeRef);
            hasModifications |= processorResult.isModified();
            if (processorResult.getPostProcessor() == null) continue;
            if (postProcessor == null) {
                postProcessor = processorResult.getPostProcessor();
                continue;
            }
            if (postProcessor instanceof ChainingContentPostProcessor) {
                ((ChainingContentPostProcessor)postProcessor).add(processorResult.getPostProcessor());
                continue;
            }
            ChainingContentPostProcessor chain = new ChainingContentPostProcessor();
            chain.add(postProcessor);
            chain.add(processorResult.getPostProcessor());
            postProcessor = chain;
        }
        if (!hasModifications && stopOnNoOp || out == null) {
            return new ContentFilterProcessingResult(false, postProcessor);
        }
        pkg.save(out);
        return new ContentFilterProcessingResult(true, postProcessor);
    }
}

