/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.auth.service;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.State;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceMetadataKey;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.util.UriComponentsBuilder;

public class AosAuthenticationUriService {
    private final SysAdminParams sysAdminParams;
    private final AlfrescoVirtualFileSystem virtualFileSystem;

    public AosAuthenticationUriService(SysAdminParams sysAdminParams, AlfrescoVirtualFileSystem virtualFileSystem) {
        this.sysAdminParams = sysAdminParams;
        this.virtualFileSystem = virtualFileSystem;
    }

    public String getAuthenticateResponseURI() {
        return this.getAlfrescoUrlWithSuffix("/service/aos/authenticate-response");
    }

    public String getAuthenticateResponseSuccessURI() {
        return this.getAlfrescoUrlWithSuffix("/service/aos/authenticate-response-success");
    }

    public String getIdpLoginURI(IdentityServiceConfig identityServiceConfig, IdentityServiceFacade identityServiceFacade) {
        PropertyCheck.mandatory((Object)this, (String)"identityServiceConfig", (Object)identityServiceConfig);
        PropertyCheck.mandatory((Object)this, (String)"identityServiceFacade", (Object)identityServiceFacade);
        ClientRegistration clientRegistration = identityServiceFacade.getClientRegistration();
        State state = new State();
        UriComponentsBuilder authRequest = UriComponentsBuilder.fromUriString((String)clientRegistration.getProviderDetails().getAuthorizationUri()).queryParam("client_id", new Object[]{clientRegistration.getClientId()}).queryParam("redirect_uri", new Object[]{this.getAuthenticateResponseURI()}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{String.join((CharSequence)"+", this.getScopes(clientRegistration))}).queryParam("state", new Object[]{state.toString()});
        if (StringUtils.isNotBlank((CharSequence)identityServiceConfig.getAudience())) {
            authRequest.queryParam("audience", new Object[]{identityServiceConfig.getAudience()});
        }
        return authRequest.build().toUriString();
    }

    private String getAlfrescoUrlWithSuffix(String suffix) {
        return UrlUtil.getAlfrescoUrl((SysAdminParams)this.sysAdminParams) + suffix;
    }

    private Set<String> getScopes(ClientRegistration clientRegistration) {
        return Optional.ofNullable(clientRegistration.getProviderDetails()).map(ClientRegistration.ProviderDetails::getConfigurationMetadata).map(metadata -> metadata.get(IdentityServiceMetadataKey.SCOPES_SUPPORTED.getValue())).filter(Scope.class::isInstance).map(Scope.class::cast).map(this::getSupportedScopes).orElse(clientRegistration.getScopes());
    }

    private Set<String> getSupportedScopes(Scope scopes) {
        return scopes.stream().filter(this::hasAOSScope).map(Identifier::getValue).collect(Collectors.toSet());
    }

    private boolean hasAOSScope(Scope.Value scope) {
        return this.virtualFileSystem.getIdentityServiceScopes().contains(scope.getValue());
    }
}

