/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.auth;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import org.alfresco.module.aosmodule.auth.AosHttpServletRequestWrapper;
import org.alfresco.module.aosmodule.auth.OfbaHttpServletRequestWrapper;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationCookiesService;
import org.alfresco.module.aosmodule.auth.service.AosAuthenticationUriService;
import org.alfresco.module.aosmodule.auth.service.AosIDSContextService;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class AosWebDavAuthenticationFilterInterceptor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AosWebDavAuthenticationFilterInterceptor.class);
    private final AosAuthenticationCookiesService cookiesService;
    private final AosAuthenticationUriService uriService;
    private final AosIDSContextService idsContextService;
    private IdentityServiceConfig identityServiceConfig;
    private IdentityServiceFacade identityServiceFacade;
    private AlfrescoVirtualFileSystem alfrescoVirtualFileSystem;

    public AosWebDavAuthenticationFilterInterceptor(AosAuthenticationCookiesService cookiesService, AosAuthenticationUriService uriService, AosIDSContextService idsContextService, AlfrescoVirtualFileSystem alfrescoVirtualFileSystem) {
        this.cookiesService = cookiesService;
        this.uriService = uriService;
        this.idsContextService = idsContextService;
        this.alfrescoVirtualFileSystem = alfrescoVirtualFileSystem;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("doFilter")) {
            Object[] args = invocation.getArguments();
            HttpServletResponse response = (HttpServletResponse)args[2];
            response.addHeader("MicrosoftSharePointTeamServices", "15.0.0.4420");
            long sizeLimit = this.alfrescoVirtualFileSystem.getWebDavHelper().getSizeLimit();
            if (this.isIDS()) {
                if (this.interceptDoFilter(invocation, sizeLimit)) {
                    return null;
                }
            } else {
                HttpServletRequest request = (HttpServletRequest)args[1];
                args[1] = new AosHttpServletRequestWrapper(request, sizeLimit);
            }
        }
        return invocation.proceed();
    }

    private boolean isIDS() {
        this.identityServiceConfig = this.idsContextService.getIdentityServiceBean(IdentityServiceConfig.class);
        this.identityServiceFacade = this.idsContextService.getIdentityServiceBean(IdentityServiceFacade.class);
        return this.identityServiceConfig != null && this.identityServiceFacade != null;
    }

    private boolean interceptDoFilter(MethodInvocation invocation, long sizeLimit) throws IOException {
        Object[] args = invocation.getArguments();
        HttpServletRequest request = (HttpServletRequest)args[1];
        HttpServletResponse response = (HttpServletResponse)args[2];
        String authToken = this.cookiesService.getCookie("ALFRESCO_AOS_TOKEN", request);
        String refreshToken = this.cookiesService.getCookie("ALFRESCO_AOS_REFRESH_TOKEN", request);
        String authTokenExpiration = this.cookiesService.getCookie("ALFRESCO_AOS_TOKEN_EXPIRATION", request);
        if (authToken != null) {
            try {
                if (AosWebDavAuthenticationFilterInterceptor.isAuthTokenExpired(authTokenExpiration)) {
                    authToken = this.refreshAuthToken(refreshToken, response);
                }
                AosWebDavAuthenticationFilterInterceptor.decorateBearerHeader(args, request, authToken, sizeLimit);
                return false;
            }
            catch (Exception e) {
                LOG.debug("Error while trying to refresh AOS Auth Token: {}", (Object)e.getMessage());
                this.resetAosCookies(response);
            }
        }
        this.respondWithAuthChallenge(response);
        return true;
    }

    private static boolean isAuthTokenExpired(String authTokenExpiration) {
        return Instant.now().compareTo(Instant.ofEpochMilli(Long.parseLong(authTokenExpiration))) >= 0;
    }

    private String refreshAuthToken(String refreshToken, HttpServletResponse response) {
        IdentityServiceFacade.AccessTokenAuthorization authorization = this.doRefreshAuthToken(refreshToken);
        IdentityServiceFacade.AccessToken accessToken = authorization.getAccessToken();
        String authToken = accessToken.getTokenValue();
        refreshToken = authorization.getRefreshTokenValue();
        String authTokenExpiration = String.valueOf(accessToken.getExpiresAt().toEpochMilli());
        this.cookiesService.addCookie("ALFRESCO_AOS_TOKEN_EXPIRATION", authTokenExpiration, response);
        this.cookiesService.addCookie("ALFRESCO_AOS_TOKEN", authToken, response);
        this.cookiesService.addCookie("ALFRESCO_AOS_REFRESH_TOKEN", refreshToken, response);
        return authToken;
    }

    private IdentityServiceFacade.AccessTokenAuthorization doRefreshAuthToken(String refreshToken) {
        try {
            return this.identityServiceFacade.authorize(IdentityServiceFacade.AuthorizationGrant.refreshToken((String)refreshToken));
        }
        catch (IdentityServiceFacade.AuthorizationException e) {
            throw new AuthenticationException("Failed to authorize using refresh token grant.", (Throwable)e);
        }
    }

    private void resetAosCookies(HttpServletResponse response) {
        this.cookiesService.resetCookie("ALFRESCO_AOS_TOKEN_EXPIRATION", response);
        this.cookiesService.resetCookie("ALFRESCO_AOS_TOKEN", response);
        this.cookiesService.resetCookie("ALFRESCO_AOS_REFRESH_TOKEN", response);
    }

    private static void decorateBearerHeader(Object[] args, HttpServletRequest request, String authToken, long sizeLimit) {
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("Authorization", "Bearer " + authToken);
        args[1] = new OfbaHttpServletRequestWrapper(additionalHeaders, request, sizeLimit);
    }

    private void respondWithAuthChallenge(HttpServletResponse response) throws IOException {
        response.setStatus(403);
        response.setHeader("X-FORMS_BASED_AUTH_REQUIRED", this.uriService.getIdpLoginURI(this.identityServiceConfig, this.identityServiceFacade));
        response.setHeader("X-FORMS_BASED_AUTH_RETURN_URL", this.uriService.getAuthenticateResponseSuccessURI());
        response.setHeader("X-FORMS_BASED_AUTH_DIALOG_SIZE", "800x600");
        response.getWriter().print("<html><body>");
        response.getWriter().print(I18NUtil.getMessage((String)"aos.auth.ofba_required.message"));
        response.getWriter().print("</body></html>");
        response.getWriter().flush();
        response.flushBuffer();
    }
}

