/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.exceptions.MalformedVermeerRequestException;
import org.alfresco.officeservices.protocol.VermeerRequest;

public class VermeerParameterVectorUrlinfo {
    protected List<String> value = null;

    public VermeerParameterVectorUrlinfo(String data) throws MalformedVermeerRequestException {
        if (data != null) {
            if (data.length() < 2 || data.charAt(0) != '[' || data.charAt(data.length() - 1) != ']') {
                throw new MalformedVermeerRequestException("invalid block marker");
            }
            this.value = new ArrayList<String>();
            data = data.substring(1, data.length() - 1);
            int pos = 0;
            while (pos < data.length()) {
                StringBuffer url = new StringBuffer();
                pos = this.parseUrlinfo(data, pos, url);
                this.value.add(url.toString());
                if (pos >= data.length()) continue;
                if (data.charAt(pos) != ';') {
                    throw new MalformedVermeerRequestException("Expector vector separator");
                }
                ++pos;
            }
        }
    }

    protected int parseUrlinfo(String data, int start, StringBuffer url) throws MalformedVermeerRequestException {
        if (data.length() - start < 5 || !data.substring(start, start + 5).equals("[url=")) {
            throw new MalformedVermeerRequestException("Missing url in URLINFO block");
        }
        start += 5;
        start = this.parseString(data, start, url);
        if (data.length() - start < 12 || !data.substring(start, start + 12).equals(";meta_info=[")) {
            throw new MalformedVermeerRequestException("Missing meta_info in URLINFO block");
        }
        start += 12;
        while (start < data.length() && data.charAt(start) != ']') {
            ++start;
        }
        if (start == data.length()) {
            throw new MalformedVermeerRequestException("Unterminated meta_info block");
        }
        if (++start == data.length()) {
            throw new MalformedVermeerRequestException("Unterminated meta_info block");
        }
        if (data.charAt(start) != ']') {
            throw new MalformedVermeerRequestException("Unterminated meta_info block");
        }
        return start + 1;
    }

    protected int parseString(String data, int start, StringBuffer result) throws MalformedVermeerRequestException {
        int i;
        int max = data.length();
        boolean escaped = false;
        block16: for (i = start; i < max; ++i) {
            char c = data.charAt(i);
            if (escaped) {
                switch (c) {
                    case '\\': {
                        result.append('\\');
                        break;
                    }
                    case '=': {
                        result.append('=');
                        break;
                    }
                    case '[': {
                        result.append('[');
                        break;
                    }
                    case ']': {
                        result.append(']');
                        break;
                    }
                    case ';': {
                        result.append(';');
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        break;
                    }
                    default: {
                        throw new MalformedVermeerRequestException("invalid escapeing sequence");
                    }
                }
                escaped = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    escaped = true;
                    continue block16;
                }
                case '=': {
                    throw new MalformedVermeerRequestException("invalid escapeing sequence");
                }
                case '[': {
                    throw new MalformedVermeerRequestException("invalid escapeing sequence");
                }
                case ']': {
                    return i;
                }
                case ';': {
                    return i;
                }
                case '\"': {
                    throw new MalformedVermeerRequestException("invalid escapeing sequence");
                }
                default: {
                    result.append(c);
                }
            }
        }
        return i + 1;
    }

    public VermeerParameterVectorUrlinfo(VermeerRequest request, String parameterName, boolean required) throws MalformedVermeerRequestException {
        this(request.getParameter(parameterName));
        if (required && this.isNull()) {
            throw new MalformedVermeerRequestException(parameterName + " missing");
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    public int getSize() {
        return this.value.size();
    }

    public String get(int index) {
        return this.value.get(index);
    }
}

