/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.forms;

import org.alfresco.officeservices.forms.FormData;
import org.alfresco.officeservices.forms.FormResource;
import org.alfresco.officeservices.forms.InfoPathForm;

public class DefaultReviewRoutingInitForm
implements InfoPathForm {
    protected DefaultInitializationFormType type;
    protected boolean serial;
    private boolean initLock = false;
    private boolean groupTasks = false;
    private boolean noDueDate = false;
    public static final String DEFAULT_REVIEW_ROUTING_INIT_FORM_URN = "urn:schemas-microsoft-com:office:infopath:workflow:ReviewRouting-Init:$Subst:LCID;";

    public DefaultReviewRoutingInitForm(DefaultInitializationFormType type, boolean serial) {
        this.type = type;
        this.serial = serial;
    }

    public DefaultReviewRoutingInitForm(DefaultInitializationFormType type, boolean serial, boolean initLock, boolean groupTasks, boolean noDueDate) {
        this.type = type;
        this.serial = serial;
        this.initLock = initLock;
        this.groupTasks = groupTasks;
        this.noDueDate = noDueDate;
    }

    @Override
    public boolean hasFormResource() {
        return false;
    }

    @Override
    public FormResource getFormResource() {
        return null;
    }

    @Override
    public FormData getFormData() {
        return new DefaultReviewRoutingInitFormData(this.type, this.serial, this.initLock, this.groupTasks, this.noDueDate);
    }

    @Override
    public String getURN() {
        return DEFAULT_REVIEW_ROUTING_INIT_FORM_URN;
    }

    public static enum DefaultInitializationFormType {
        REQUEST_APPROVAL,
        COLLECT_FEEDBACK;

    }

    private class DefaultReviewRoutingInitFormData
    implements FormData {
        private DefaultInitializationFormType type;
        private boolean serial;
        private boolean initLock = false;
        private boolean groupTasks = false;
        private boolean noDueDate = false;

        private DefaultReviewRoutingInitFormData(DefaultInitializationFormType type, boolean serial, boolean initLock, boolean groupTasks, boolean noDueDate) {
            this.type = type;
            this.serial = serial;
            this.initLock = initLock;
            this.groupTasks = groupTasks;
            this.noDueDate = noDueDate;
        }

        @Override
        public String getTransferData() {
            StringBuilder transferData = new StringBuilder();
            transferData.append("<my:myFields xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:my=\"http://schemas.microsoft.com/office/infopath/2003/myXSD\" xml:lang=\"en-us\">");
            transferData.append("<my:Reviewers></my:Reviewers>");
            transferData.append("<my:CC></my:CC>");
            transferData.append("<my:DueDate xsi:nil=\"true\"></my:DueDate>");
            transferData.append("<my:Description></my:Description>");
            transferData.append("<my:Title></my:Title>");
            switch (this.type) {
                case REQUEST_APPROVAL: {
                    transferData.append("<my:DefaultTaskType>1</my:DefaultTaskType>");
                    break;
                }
                case COLLECT_FEEDBACK: {
                    transferData.append("<my:DefaultTaskType>2</my:DefaultTaskType>");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown default review routing form type");
                }
            }
            transferData.append("<my:CreateTasksInSerial>" + (this.serial ? "true" : "false") + "</my:CreateTasksInSerial>");
            transferData.append("<my:AllowDelegation>true</my:AllowDelegation>");
            transferData.append("<my:AllowChangeRequests>true</my:AllowChangeRequests>");
            transferData.append("<my:StopOnAnyReject xsi:nil=\"true\"></my:StopOnAnyReject>");
            transferData.append("<my:WantedTasks xsi:nil=\"true\"></my:WantedTasks>");
            transferData.append("<my:SetMetadataOnSuccess>false</my:SetMetadataOnSuccess>");
            transferData.append("<my:MetadataSuccessField></my:MetadataSuccessField>");
            transferData.append("<my:MetadataSuccessValue></my:MetadataSuccessValue>");
            transferData.append("<my:ApproveWhenComplete>false</my:ApproveWhenComplete>");
            transferData.append("<my:TimePerTaskVal xsi:nil=\"true\"></my:TimePerTaskVal>");
            transferData.append("<my:TimePerTaskType xsi:nil=\"true\"></my:TimePerTaskType>");
            transferData.append("<my:Voting>false</my:Voting>");
            transferData.append("<my:MetadataTriggerField></my:MetadataTriggerField>");
            transferData.append("<my:MetadataTriggerValue></my:MetadataTriggerValue>");
            transferData.append("<my:InitLock>" + (this.initLock ? "true" : "false") + "</my:InitLock>");
            transferData.append("<my:MetadataStop>false</my:MetadataStop>");
            transferData.append("<my:ItemChangeStop>false</my:ItemChangeStop>");
            transferData.append("<my:GroupTasks>" + (this.groupTasks ? "true" : "false") + "</my:GroupTasks>");
            if (this.noDueDate) {
                transferData.append("<my:NoDueDate>true</my:NoDueDate>");
            }
            transferData.append("</my:myFields>");
            return transferData.toString();
        }
    }
}

