/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

import java.util.Date;
import org.alfresco.officeservices.datamodel.FieldDefinition;

public class FieldValue {
    private FieldDefinition definition;
    private Object value;

    public FieldValue(FieldDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("FieldDefinition required");
        }
        this.definition = definition;
        this.value = null;
    }

    public FieldValue(FieldDefinition definition, Object value) {
        if (definition == null) {
            throw new IllegalArgumentException("FieldDefinition required");
        }
        this.definition = definition;
        this.setValue(value);
    }

    public FieldDefinition getDefinition() {
        return this.definition;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.value = null;
            return;
        }
        switch (this.definition.getFieldType()) {
            case TEXT: 
            case NOTE: 
            case CHOICE: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("Value must be an instance of java.lang.String");
            }
            case DATE_TIME: {
                if (value instanceof Date) break;
                throw new IllegalArgumentException("Value must be an instance of java.util.Date");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("Value must be an instance of java.lang.Boolean");
            }
            case NUMBER: {
                if (value instanceof Number) break;
                throw new IllegalArgumentException("Value must be an instance of java.lang.Number");
            }
            default: {
                throw new IllegalStateException("Unknown FieldType");
            }
        }
    }
}

