/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

import java.text.ParseException;
import org.alfresco.officeservices.datamodel.Guid;

public final class ContentTypeId {
    private static String SYSTEM_ID_STRING = "0x";
    public static ContentTypeId SYSTEM = new ContentTypeId(null, SYSTEM_ID_STRING);
    public static ContentTypeId ITEM = SYSTEM.getChild((byte)1);
    public static ContentTypeId DOCUMENT = ITEM.getChild((byte)1);
    public static ContentTypeId FOLDER = ITEM.getChild((byte)32);
    private String contentTypeId;
    private ContentTypeId parent;
    private byte id;
    private Guid guid;

    private ContentTypeId(ContentTypeId parent, String contentTypeId) {
        this.parent = parent;
        this.contentTypeId = contentTypeId;
    }

    private ContentTypeId(ContentTypeId parent, byte id) {
        this.parent = parent;
        this.id = id;
        StringBuilder sb = new StringBuilder(parent.contentTypeId.length() + 2);
        sb.append(parent.contentTypeId);
        String idStr = Integer.toHexString(id);
        if (idStr.length() < 2) {
            sb.append('0');
        }
        sb.append(idStr);
        this.contentTypeId = sb.toString();
    }

    private ContentTypeId(ContentTypeId parent, Guid guid) {
        this.parent = parent;
        this.guid = guid;
        StringBuilder sb = new StringBuilder(parent.contentTypeId.length() + 34);
        sb.append(parent.contentTypeId);
        sb.append('0');
        sb.append('0');
        sb.append(guid.toCondensedString().toUpperCase());
        this.contentTypeId = sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ContentTypeId && ((ContentTypeId)obj).contentTypeId.equals(this.contentTypeId);
    }

    public String toString() {
        return this.contentTypeId;
    }

    public ContentTypeId getParent() {
        return this.parent;
    }

    public boolean isIdBased() {
        return this.id != 0;
    }

    public boolean isGuidBased() {
        return this.guid != null;
    }

    public byte getId() {
        if (this.id == 0) {
            throw new IllegalStateException("This ContentTypeId is not ID based.");
        }
        return this.id;
    }

    public Guid getGuid() {
        if (this.guid == null) {
            throw new IllegalStateException("This ContentTypeId is not Guid based.");
        }
        return this.guid;
    }

    public boolean equalsOrExtends(ContentTypeId contentTypeId) {
        for (ContentTypeId test = this; test != null; test = test.getParent()) {
            if (!test.equals(contentTypeId)) continue;
            return true;
        }
        return false;
    }

    public ContentTypeId getChild(byte id) {
        if (id == 0) {
            throw new IllegalArgumentException("Id cannot be 0");
        }
        if (this.contentTypeId.length() + 2 > 1026) {
            throw new IllegalArgumentException("Child ContentTypeId exceeds maximum of 512 bytes (1024 hex chars)");
        }
        return new ContentTypeId(this, id);
    }

    public ContentTypeId getChild(Guid guid) {
        if (guid == null) {
            throw new IllegalArgumentException("Guid cannot be null");
        }
        if (this.contentTypeId.length() + 34 > 1026) {
            throw new IllegalArgumentException("Child ContentTypeId exceeds maximum of 512 bytes (1024 hex chars)");
        }
        return new ContentTypeId(this, guid);
    }

    public static ContentTypeId parse(String id) throws ParseException {
        if (!id.startsWith(SYSTEM_ID_STRING)) {
            throw new ParseException("ContentTypeId does not start with SYSTEM identifier.", 0);
        }
        int nextPos = SYSTEM_ID_STRING.length();
        ContentTypeId result = SYSTEM;
        while (nextPos < id.length()) {
            if (nextPos + 2 > id.length()) {
                throw new ParseException("Unexpected end of identifier. Expected at least two hex characters. errorPos=" + nextPos, nextPos);
            }
            Byte hexByte = 0;
            try {
                hexByte = Byte.parseByte(id.substring(nextPos, nextPos + 2), 16);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Invalid character. Expected two hex characters. errorPos=" + nextPos, nextPos);
            }
            nextPos += 2;
            if (hexByte == 0) {
                if (nextPos + 32 > id.length()) {
                    throw new ParseException("Unexpected end of identifier. Expected at least 32 hex characters. errorPos=" + nextPos, nextPos);
                }
                Guid guid = null;
                try {
                    guid = Guid.parse(id.substring(nextPos, nextPos + 32));
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid character. Expected 32 hex characters. errorPos=" + nextPos, nextPos);
                }
                nextPos += 32;
                result = result.getChild(guid);
                continue;
            }
            result = result.getChild(hexByte);
        }
        return result;
    }
}

