/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.officeservices.AbstractSoapService;
import org.alfresco.officeservices.lists.ContentTypeFieldDefinition;

public class WebsGetContentTypeContentType {
    protected String id;
    protected String name;
    protected String group;
    protected String description;
    protected String folderTargetName;
    protected String version = "0";
    protected List<ContentTypeFieldDefinition> fields = new ArrayList<ContentTypeFieldDefinition>();
    protected String customXsnLocation;
    protected boolean customXsnCached = false;
    protected boolean customXsnOpenByDefault = false;
    protected String customXsnScope;
    protected String featureId = "{695b6570-a48b-4a8e-8ea5-26ea7fc1d162}";
    public static final String FEATUREID_CTYPES_STANDARD_CONTENT_TYPE_DEFINITIONS = "{695b6570-a48b-4a8e-8ea5-26ea7fc1d162}";

    public WebsGetContentTypeContentType(String id, String name, String group, String description, String folderTargetName) {
        this.id = id;
        this.name = name;
        this.group = group;
        this.description = description;
        this.folderTargetName = folderTargetName;
    }

    public void setCustomXsn(String location, boolean cached, boolean openByDefault, String scope) {
        this.customXsnLocation = location;
        this.customXsnCached = cached;
        this.customXsnOpenByDefault = openByDefault;
        this.customXsnScope = scope;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void addFieldDefinition(ContentTypeFieldDefinition field) {
        this.fields.add(field);
    }

    public List<ContentTypeFieldDefinition> getFields() {
        return this.fields;
    }

    public void write(PrintStream out) throws IOException {
        out.print("<ContentType");
        AbstractSoapService.writeXmlAttribute(out, "ID", this.id, true);
        AbstractSoapService.writeXmlAttribute(out, "Name", this.name, true);
        AbstractSoapService.writeXmlAttribute(out, "Group", this.group, true);
        AbstractSoapService.writeXmlAttribute(out, "Description", this.description, true);
        AbstractSoapService.writeXmlAttribute(out, "Version", this.version, true);
        AbstractSoapService.writeXmlAttribute(out, "FeatureId", this.featureId, true);
        out.print(">");
        out.print("<Folder");
        AbstractSoapService.writeXmlAttribute(out, "TargetName", this.folderTargetName, true);
        out.print(" />");
        out.print("<Fields>");
        for (ContentTypeFieldDefinition field : this.fields) {
            field.write(out);
        }
        out.print("</Fields>");
        out.print("<XmlDocuments>");
        if (this.customXsnLocation != null) {
            out.print("<XmlDocument NamespaceURI=\"http://schemas.microsoft.com/office/2006/metadata/customXsn\">");
            out.print("<ntns:customXsn xmlns:ntns=\"http://schemas.microsoft.com/office/2006/metadata/customXsn\">");
            out.print("<ntns:xsnLocation>");
            AbstractSoapService.writeEncoded(out, this.customXsnLocation);
            out.print("</ntns:xsnLocation>");
            out.print("<ntns:cached>");
            out.print(this.customXsnCached ? "TRUE" : "FALSE");
            out.print("</ntns:cached>");
            out.print("<ntns:openByDefault>");
            out.print(this.customXsnOpenByDefault ? "TRUE" : "FALSE");
            out.print("</ntns:openByDefault>");
            out.print("<ntns:xsnScope>");
            AbstractSoapService.writeEncoded(out, this.customXsnScope);
            out.print("</ntns:xsnScope>");
            out.print("</ntns:customXsn>");
            out.print("</XmlDocument>");
        }
        out.print("<XmlDocument NamespaceURI=\"http://schemas.microsoft.com/sharepoint/v3/contenttype/forms\">");
        out.print("<FormTemplates xmlns=\"http://schemas.microsoft.com/sharepoint/v3/contenttype/forms\">");
        out.print("<Display>DocumentLibraryForm</Display>");
        out.print("<Edit>DocumentLibraryForm</Edit>");
        out.print("<New>DocumentLibraryForm</New>");
        out.print("</FormTemplates>");
        out.print("</XmlDocument>");
        out.print("</XmlDocuments>");
        out.print("</ContentType>");
    }
}

