/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.alfresco.officeservices.AbstractAuthorService;
import org.alfresco.officeservices.GetOption;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AccessDeniedException;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.protocol.VermeerParameterVectorString;
import org.alfresco.officeservices.protocol.VermeerParameterVectorUrlinfo;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionaryEmpty;
import org.alfresco.officeservices.protocol.VermeerReturnDictionaryService;
import org.alfresco.officeservices.protocol.VermeerReturnDocumentList;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnStringValue;
import org.alfresco.officeservices.protocol.VermeerReturnUrlList;
import org.alfresco.officeservices.protocol.VermeerReturnVectorUrlDirectory;
import org.alfresco.officeservices.vfs.CheckoutResult;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;

public abstract class StandardAuthorService
extends AbstractAuthorService {
    private static final long serialVersionUID = 1687719176541245779L;
    private static final ServiceLogger logger = new ServiceLogger(StandardAuthorService.class);
    public static final int RESULT_OK = 0;
    public static final int RESULT_FAILED = -1;
    public static final int RESULT_CHECKEDOUTBYDIFFERENTUSER = -2;

    public abstract VirtualFileSystem getVirtualFileSystem(UserData var1) throws AuthenticationRequiredException;

    @Override
    public void openService(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) throws IOException, VermeerException, AuthenticationRequiredException {
        String username;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if ((username = vermeerRequest.getUserData().getUsername()) == null) {
            logger.error("openService: username is missing.");
            vermeerResponse.error("unknown user");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        String serviceName = this.getServiceName(vermeerRequest);
        String sitePrefix = this.getSitePrefix(vermeerRequest.getRequest());
        if (logger.isDebugEnabled()) {
            logger.debug("openService: username=" + username);
            logger.debug("openService: serviceName=" + serviceName);
            logger.debug("openService: sitePrefix=" + sitePrefix);
        }
        VermeerReturnList serviceDescription = new VermeerReturnList();
        serviceDescription.add("service_name", new VermeerReturnStringValue(serviceName));
        serviceDescription.add("meta_info", new VermeerReturnDictionaryService(serviceName, sitePrefix, username, this.isCaseSensitiveURLs(vermeerRequest.getUserData())));
        vermeerResponse.addReturnItem("service", serviceDescription);
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected String getServiceName(VermeerRequest vermeerRequest) {
        return vermeerRequest.getThisServiceName();
    }

    protected boolean isCaseSensitiveURLs(UserData userData) throws AuthenticationRequiredException {
        return true;
    }

    protected boolean onBeforeGetDocument(VFSDocumentNode document, GetOption getOption) {
        return true;
    }

    protected void onAfterGetDocument(VFSDocumentNode document, GetOption getOption, int result) {
    }

    @Override
    public void getDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String documentName, GetOption getOption, int force, int timeout) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getDocument: documentName=" + documentName);
        }
        VFSDocumentNode document = null;
        UserData userData = vermeerRequest.getUserData();
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, documentName, 260);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("getDocument: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            logger.debug("getDocument: document not found. documentName=" + documentName);
            vermeerResponse.error("document not found");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (!this.onBeforeGetDocument(document, getOption)) {
            if (logger.isDebugEnabled()) {
                logger.debug("getDocument: onBeforeGetDocument prevented opening the document.");
            }
            vermeerResponse.error("EventManager prevented opening the document.");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (getOption == GetOption.CHKOUTEXCLUSIVE || getOption == GetOption.CHKOUTNONEXCLUSIVE) {
            CheckoutResult coresult;
            if (logger.isDebugEnabled()) {
                logger.debug("getDocument: getOption requests document checkout. timeout=" + timeout);
            }
            if ((coresult = document.checkout(timeout, null, 260)) != CheckoutResult.OK) {
                if (coresult == CheckoutResult.DIFFERENTUSER) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getDocument: can not checkout. document is locked by a different user. documentName=" + documentName);
                    }
                    vermeerResponse.error(589838, 0, "This file is locked by a different user.");
                    this.onAfterGetDocument(document, getOption, -2);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getDocument: checkout failed. documentName=" + documentName);
                    }
                    vermeerResponse.error("error checking out document");
                    this.onAfterGetDocument(document, getOption, -1);
                }
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getDocument: document checkout successfull.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getDocument: sending metadata...");
        }
        VermeerReturnList documentDescription = new VermeerReturnList();
        documentDescription.add("document_name", new VermeerReturnStringValue(documentName));
        documentDescription.add("meta_info", document.getVermeerMetaInfoDictionary(260));
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully retrieved document '" + documentName + "'"));
        vermeerResponse.addReturnItem("document", documentDescription);
        vermeerResponse.send();
        if (logger.isDebugEnabled()) {
            logger.debug("getDocument: sending content...");
        }
        try {
            document.emitContent((OutputStream)vermeerResponse.getOutputStream(), 260);
        }
        catch (Exception e) {
            this.onAfterGetDocument(document, getOption, -1);
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        this.onAfterGetDocument(document, getOption, 0);
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected boolean onBeforePutDocument(VFSDocumentNode document) {
        return true;
    }

    protected void onAfterPutDocument(VFSDocumentNode document, int result) {
    }

    protected boolean onBeforeCreateDocument(String documentName) {
        return true;
    }

    protected void onAfterCreateDocument(String documentName, int result) {
    }

    @Override
    public void putDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String documentName, Map<String, String> metaInfo, String putOption, String comment, boolean keepCheckedOut) throws IOException, VermeerException, AuthenticationRequiredException, AccessDeniedException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("putDocument: documentName=" + documentName);
        }
        UserData userData = vermeerRequest.getUserData();
        VirtualFileSystem vfs = this.getVirtualFileSystem(userData);
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)vfs.getNodeByPath(userData, documentName, 262);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("putDocument: path does not point to a file. documentName=" + documentName);
            }
            vermeerResponse.error("path does not point to a file");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (document == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("putDocument: document not found. creating new one.");
            }
            if (!this.onBeforeCreateDocument(documentName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("putDocument: EventManager prevented creating the document.");
                }
                vermeerResponse.error("EventManager prevented creating the document.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            document = vfs.createDocument(userData, documentName, vermeerRequest, 262);
            if (document == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("putDocument: error creating document.");
                }
                this.onAfterCreateDocument(documentName, -1);
                vermeerResponse.error("error creating document");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            this.onAfterCreateDocument(documentName, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("putDocument: document creation successfull.");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("putDocument: document found. storing new content.");
            }
            if (metaInfo.isEmpty()) {
                logger.debug("putDocument: No overwrite rquest. Informing caller of existing document.");
                VermeerReturnList statusDescription = new VermeerReturnList();
                statusDescription.add("status", new VermeerReturnStringValue("589826"));
                statusDescription.add("osstatus", new VermeerReturnStringValue("0"));
                statusDescription.add("msg", new VermeerReturnStringValue("File already esists."));
                statusDescription.add("osmsg", new VermeerReturnStringValue(""));
                vermeerResponse.addReturnItem("status", statusDescription);
                VermeerReturnList documentDescription = new VermeerReturnList();
                vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("could not put document '" + documentName + "' as '" + documentName + "#"));
                documentDescription.add("document_name", new VermeerReturnStringValue(documentName));
                documentDescription.add("meta_info", document.getVermeerMetaInfoDictionary(262));
                vermeerResponse.addReturnItem("document", documentDescription);
                vermeerResponse.send();
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (!this.onBeforePutDocument(document)) {
                logger.debug("putDocument: EventManager prevented saving the document.");
                vermeerResponse.error("EventManager prevented saving the document.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (!document.storeContent(vermeerRequest, 262)) {
                logger.debug("putDocument: error storing new content.");
                this.onAfterPutDocument(document, -1);
                vermeerResponse.error("error storing document");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            this.onAfterPutDocument(document, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("putDocument: document update successfull.");
            }
        }
        VermeerReturnList documentDescription = new VermeerReturnList();
        documentDescription.add("document_name", new VermeerReturnStringValue(documentName));
        documentDescription.add("meta_info", document.getVermeerMetaInfoDictionary(262));
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully put document '" + documentName + "'"));
        vermeerResponse.addReturnItem("document", documentDescription);
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void moveDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String oldUrl, String newUrl, String put_option, String rename_option) throws IOException, VermeerException, AuthenticationRequiredException {
        UserData userData;
        VirtualFileSystem vfs;
        VFSNode vfsnode;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        int p = oldUrl.lastIndexOf(47);
        String oldParent = "";
        if (p >= 0) {
            oldParent = oldUrl.substring(0, p);
        }
        String newParent = "";
        String newName = newUrl;
        p = newUrl.lastIndexOf(47);
        if (p >= 0) {
            newParent = newUrl.substring(0, p);
            newName = newUrl.substring(p + 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("moveDocument: oldParent=" + oldParent + " newParent=" + newParent + " newName=" + newName);
        }
        if ((vfsnode = (vfs = this.getVirtualFileSystem(userData = vermeerRequest.getUserData())).getNodeByPath(userData, oldUrl, 264)) == null) {
            logger.debug("moveDocument: Can not find oldUrl in filesystem.");
            vermeerResponse.error("error moving document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        VermeerReturnDocumentList documentList = new VermeerReturnDocumentList();
        VermeerReturnDocumentList movedDocs = new VermeerReturnDocumentList();
        VermeerReturnVectorUrlDirectory movedDirs = new VermeerReturnVectorUrlDirectory();
        if (oldParent.equals(newParent)) {
            if (logger.isDebugEnabled()) {
                logger.debug("moveDocument: Renaming node.");
            }
            if (!vfsnode.rename(newName, 264)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("moveDocument: Error renaming node.");
                }
                vermeerResponse.error("error moving document");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (vfsnode instanceof VFSDocumentNode) {
                movedDocs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
            } else {
                movedDirs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("moveDocument: Moving node.");
            }
            if (!vfsnode.move(userData, newUrl, 264)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("moveDocument: Error renaming node.");
                }
                vermeerResponse.error("error moving document");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (vfsnode instanceof VFSDocumentNode) {
                movedDocs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
            } else {
                movedDirs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
            }
        }
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully moved document."));
        vermeerResponse.addReturnItem("oldUrl", new VermeerReturnStringValue(oldUrl));
        vermeerResponse.addReturnItem("newUrl", new VermeerReturnStringValue(newUrl));
        vermeerResponse.addReturnItem("document_list", documentList);
        vermeerResponse.addReturnItem("moved_docs", movedDocs);
        vermeerResponse.addReturnItem("moved_dirs", movedDirs);
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void moveDocument_Copy(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String oldUrl, String newUrl, String put_option, String rename_option) throws IOException, VermeerException, AuthenticationRequiredException {
        UserData userData;
        VirtualFileSystem vfs;
        VFSNode vfsnode;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("moveDocument_Copy: oldUrl=" + oldUrl + " newUrl=" + newUrl);
        }
        if ((vfsnode = (vfs = this.getVirtualFileSystem(userData = vermeerRequest.getUserData())).getNodeByPath(userData, oldUrl, 264)) == null) {
            logger.debug("moveDocument_Copy: Can not find oldUrl in filesystem.");
            vermeerResponse.error("error copying document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        VermeerReturnDocumentList documentList = new VermeerReturnDocumentList();
        VermeerReturnDocumentList movedDocs = new VermeerReturnDocumentList();
        VermeerReturnVectorUrlDirectory movedDirs = new VermeerReturnVectorUrlDirectory();
        if (!vfsnode.copy(userData, newUrl, 264)) {
            if (logger.isDebugEnabled()) {
                logger.debug("moveDocument_Copy: Error copying node.");
            }
            vermeerResponse.error("error copying document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (vfsnode instanceof VFSDocumentNode) {
            movedDocs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
        } else {
            movedDirs.add(newUrl, vfsnode.getVermeerMetaInfoDictionary(264));
        }
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully moved document."));
        vermeerResponse.addReturnItem("oldUrl", new VermeerReturnStringValue(oldUrl));
        vermeerResponse.addReturnItem("newUrl", new VermeerReturnStringValue(newUrl));
        vermeerResponse.addReturnItem("document_list", documentList);
        vermeerResponse.addReturnItem("moved_docs", movedDocs);
        vermeerResponse.addReturnItem("moved_dirs", movedDirs);
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void getDocsMetaInfo(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, VermeerParameterVectorString url_list) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        UserData userData = vermeerRequest.getUserData();
        VirtualFileSystem vfs = this.getVirtualFileSystem(userData);
        String sitePrefix = this.getSitePrefix(vermeerRequest.getRequest());
        VermeerReturnDocumentList documentsList = new VermeerReturnDocumentList();
        VermeerReturnVectorUrlDirectory directoriesList = new VermeerReturnVectorUrlDirectory();
        VermeerReturnUrlList failedUrls = new VermeerReturnUrlList();
        for (int i = 0; i < url_list.getSize(); ++i) {
            VFSNode vfsnode;
            String requestedUrl = url_list.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug("getDocsMetaInfo: requestedUrl[" + i + "]=" + requestedUrl);
            }
            if (requestedUrl.length() >= sitePrefix.length() + 1 && requestedUrl.substring(0, sitePrefix.length() + 1).equalsIgnoreCase(sitePrefix + "/")) {
                requestedUrl = requestedUrl.substring(sitePrefix.length() + 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getDocsMetaInfo: cleanedRequestedUrl[" + i + "]=" + requestedUrl);
            }
            if ((vfsnode = vfs.getNodeByPath(userData, requestedUrl, 259)) != null) {
                if (vfsnode instanceof VFSDocumentNode) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getDocsMetaInfo: requestedUrl points to a document.");
                    }
                    documentsList.add(requestedUrl, vfsnode.getVermeerMetaInfoDictionary(259));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("getDocsMetaInfo: requestedUrl points to a directory.");
                }
                directoriesList.add(requestedUrl, vfsnode.getVermeerMetaInfoDictionary(259));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getDocsMetaInfo: requestedUrl not found in virtual file system.");
            }
            failedUrls.add(requestedUrl);
        }
        vermeerResponse.addReturnItem("document_list", documentsList);
        if (directoriesList.size() > 0) {
            vermeerResponse.addReturnItem("urldirs", directoriesList);
        }
        if (failedUrls.size() > 0) {
            vermeerResponse.addReturnItem("failedUrls", failedUrls);
        }
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void checkoutDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String documentName, boolean forceCheckout, boolean refreshShortTermLock, int timeout) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkoutDocument: documentName=" + documentName);
            logger.debug("checkoutDocument: timeout=" + timeout);
        }
        UserData userData = vermeerRequest.getUserData();
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, documentName, 258);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkoutDocument: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            logger.debug("checkoutDocument: document not found. documentName=" + documentName);
            vermeerResponse.error("document not found");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        CheckoutResult coresult = document.checkout(timeout, null, 258);
        if (coresult != CheckoutResult.OK) {
            if (coresult == CheckoutResult.DIFFERENTUSER) {
                if (logger.isDebugEnabled()) {
                    logger.debug("checkoutDocument: can not checkout. document is locked by a different user. documentName=" + documentName);
                }
                vermeerResponse.error(589838, 0, "This file is locked by a different user.");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("checkoutDocument: checkout failed. documentName=" + documentName);
                }
                vermeerResponse.error("error checking out document");
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkoutDocument: document checkout successfull.");
        }
        vermeerResponse.addReturnItem("meta_info", document.getVermeerMetaInfoDictionary(258));
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    public void onAfterUncheckout(VFSDocumentNode document, boolean releaseShortTerm) {
    }

    @Override
    public void uncheckoutDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String documentName, boolean force, boolean rlsshortterm) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("uncheckoutDocument: documentName=" + documentName);
            logger.debug("uncheckoutDocument: rlsshortterm=" + (rlsshortterm ? "true" : "false"));
        }
        UserData userData = vermeerRequest.getUserData();
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, documentName, 263);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("uncheckoutDocument: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            logger.debug("uncheckoutDocument: document not found. documentName=" + documentName);
            vermeerResponse.error("document not found");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (!document.uncheckout(rlsshortterm, 263)) {
            if (logger.isDebugEnabled()) {
                logger.debug("uncheckoutDocument: document checkout cancel failed.");
            }
            vermeerResponse.error("error un-checking-out document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("uncheckoutDocument: document checkout cancel successfull.");
        }
        this.onAfterUncheckout(document, rlsshortterm);
        vermeerResponse.addReturnItem("meta_info", document.getVermeerMetaInfoDictionary(262));
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void checkinDocument(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String documentName, String comment, boolean keepCheckedOut) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkinDocument: documentName=" + documentName);
            logger.debug("checkinDocument: keepCheckedOut=" + (keepCheckedOut ? "true" : "false"));
            logger.debug("checkinDocument: comment=" + comment);
        }
        UserData userData = vermeerRequest.getUserData();
        VFSDocumentNode document = null;
        try {
            document = (VFSDocumentNode)this.getVirtualFileSystem(userData).getNodeByPath(userData, documentName, 257);
        }
        catch (ClassCastException cce) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkinDocument: virtual file system returned a non-document node (i.e. a directory)");
            }
            document = null;
        }
        if (document == null) {
            logger.debug("checkinDocument: document not found. documentName=" + documentName);
            vermeerResponse.error("document not found");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (!document.checkin(comment, keepCheckedOut, 257, CheckinType.MAJOR)) {
            if (logger.isDebugEnabled()) {
                logger.debug("checkinDocument: error checking in document. documentName=" + documentName);
            }
            vermeerResponse.error("error checking in document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("checkinDocument: document checkin successfull.");
        }
        vermeerResponse.addReturnItem("meta_info", document.getVermeerMetaInfoDictionary(257));
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void listDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, String initialUrl) throws IOException, VermeerException, AuthenticationRequiredException {
        UserData userData;
        VFSNode parent;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listDocuments: initialUrl=" + initialUrl);
        }
        if ((parent = this.getVirtualFileSystem(userData = vermeerRequest.getUserData()).getNodeByPath(userData, initialUrl, 261)) == null) {
            logger.debug("listDocuments: initialUrl not found. initialUrl=" + initialUrl);
            vermeerResponse.error("initialUrl not found");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        if (parent instanceof VFSDocumentNode) {
            logger.error("listDocuments: initialUrl must not point to a document. initialUrl=" + initialUrl);
            vermeerResponse.error("initialUrl must not point to a document");
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        Object folderPath = initialUrl;
        if (((String)folderPath).length() > 1 && ((String)folderPath).charAt(0) == '/') {
            folderPath = ((String)folderPath).substring(1);
        }
        if (((String)folderPath).length() > 1 && ((String)folderPath).charAt(((String)folderPath).length() - 1) == '/') {
            folderPath = ((String)folderPath).substring(0, ((String)folderPath).length() - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("listDocuments: folderPath=" + (String)folderPath);
        }
        VermeerReturnDocumentList documentsList = new VermeerReturnDocumentList();
        VermeerReturnVectorUrlDirectory directoriesList = new VermeerReturnVectorUrlDirectory();
        directoriesList.add((String)folderPath, parent.getVermeerMetaInfoDictionary(261));
        if (((String)folderPath).length() > 0) {
            folderPath = (String)folderPath + "/";
        }
        List<VFSNode> children = parent.getEnumerableContainees(userData, 261);
        for (VFSNode childNode : children) {
            if (childNode instanceof VFSDocumentNode) {
                if (logger.isDebugEnabled()) {
                    logger.debug("listDocuments: listing document " + (String)folderPath + childNode.getName(261));
                }
                documentsList.add((String)folderPath + childNode.getName(261), childNode.getVermeerMetaInfoDictionary(261));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("listDocuments: listing directory " + (String)folderPath + childNode.getName(261));
            }
            directoriesList.add((String)folderPath + childNode.getName(261), childNode.getVermeerMetaInfoDictionary(261));
        }
        if (documentsList.size() > 0) {
            vermeerResponse.addReturnItem("document_list", documentsList);
        }
        if (directoriesList.size() > 0) {
            vermeerResponse.addReturnItem("urldirs", directoriesList);
        }
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void createUrlDirectories(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, VermeerParameterVectorUrlinfo urlDirs) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        UserData userData = vermeerRequest.getUserData();
        VirtualFileSystem vfs = this.getVirtualFileSystem(userData);
        for (int i = 0; i < urlDirs.getSize(); ++i) {
            String pathToCreate = urlDirs.get(i);
            VFSNode existingNode = vfs.getNodeByPath(userData, pathToCreate, 265);
            if (existingNode != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("createUrlDirectories: path already existing. continuing with next url. url=" + pathToCreate);
                continue;
            }
            VFSNode newFolder = vfs.createFolder(userData, pathToCreate, 265);
            if (newFolder != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("createUrlDirectories: folder creation successfull.");
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("createUrlDirectories: folder creation failed. path=" + pathToCreate);
        }
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully created folders."));
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    @Override
    public void removeDocuments(VermeerRequest vermeerRequest, VermeerResponse vermeerResponse, VermeerParameterVectorString url_list) throws IOException, VermeerException, AuthenticationRequiredException {
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        UserData userData = vermeerRequest.getUserData();
        VirtualFileSystem vfs = this.getVirtualFileSystem(userData);
        String sitePrefix = this.getSitePrefix(vermeerRequest.getRequest());
        VermeerReturnDocumentList removedDocs = new VermeerReturnDocumentList();
        VermeerReturnDocumentList failedDocs = new VermeerReturnDocumentList();
        VermeerReturnVectorUrlDirectory removedDirs = new VermeerReturnVectorUrlDirectory();
        VermeerReturnVectorUrlDirectory failedDirs = new VermeerReturnVectorUrlDirectory();
        VermeerReturnUrlList failedUrls = new VermeerReturnUrlList();
        for (int i = 0; i < url_list.getSize(); ++i) {
            VFSNode vfsnode;
            String removeUrl = url_list.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug("removeDocuments: url[" + i + "]=" + removeUrl);
            }
            if (removeUrl.length() >= sitePrefix.length() + 1 && removeUrl.substring(0, sitePrefix.length() + 1).equalsIgnoreCase(sitePrefix + "/")) {
                removeUrl = removeUrl.substring(sitePrefix.length() + 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("removeDocuments: cleanedUrl[" + i + "]=" + removeUrl);
            }
            if ((vfsnode = vfs.getNodeByPath(userData, removeUrl, 266)) != null) {
                if (vfsnode instanceof VFSDocumentNode) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("removeDocuments: Url points to a document.");
                    }
                    if (vfsnode.delete(266)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("removeDocuments: Successfully deleted document node.");
                        }
                        removedDocs.add(removeUrl, new VermeerReturnDictionaryEmpty());
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("removeDocuments: Failed deleting document node.");
                    }
                    failedDocs.add(removeUrl, new VermeerReturnDictionaryEmpty());
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("removeDocuments: Url points to a directory.");
                }
                if (vfsnode.delete(266)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("removeDocuments: Successfully deleted directory node.");
                    }
                    removedDirs.add(removeUrl, new VermeerReturnDictionaryEmpty());
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("removeDocuments: Failed deleting directory node.");
                }
                failedDirs.add(removeUrl, new VermeerReturnDictionaryEmpty());
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("removeDocuments: Url not found in virtual file system.");
            }
            failedUrls.add(removeUrl);
        }
        vermeerResponse.addReturnItem("message", new VermeerReturnStringValue("successfully removed documents."));
        if (failedDocs.size() > 0 || failedDirs.size() > 0) {
            VermeerReturnList statusDescription = new VermeerReturnList();
            statusDescription.add("status", new VermeerReturnStringValue("1966082"));
            statusDescription.add("osstatus", new VermeerReturnStringValue("0"));
            statusDescription.add("msg", new VermeerReturnStringValue("Object cannot be deleted."));
            statusDescription.add("osmsg", new VermeerReturnStringValue(""));
            vermeerResponse.addReturnItem("status", statusDescription);
        }
        vermeerResponse.addReturnItem("removed_docs", removedDocs);
        vermeerResponse.addReturnItem("removed_dirs", removedDirs);
        vermeerResponse.addReturnItem("failed_docs", failedDocs);
        vermeerResponse.addReturnItem("failed_dirs", failedDirs);
        if (failedUrls.size() > 0) {
            vermeerResponse.addReturnItem("failedUrls", failedUrls);
        }
        vermeerResponse.send();
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }
}

