/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerReturnDocumentList;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnValue;
import org.alfresco.officeservices.protocol.VermeerReturnVectorUrlDirectory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;

public class ServiceLogger {
    private static final String FQCN = ServiceLogger.class.getName();
    protected Logger errorLogger;
    protected Logger traceLogger;

    public ServiceLogger(Class<?> cls) {
        String classname = cls.getName();
        classname = classname.substring(classname.lastIndexOf(46) + 1);
        this.errorLogger = LogManager.getLogger((String)("aoservices-err." + classname));
        this.traceLogger = LogManager.getLogger((String)("aoservices-trc." + classname));
    }

    public boolean isDebugEnabled() {
        return this.errorLogger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.traceLogger.isDebugEnabled();
    }

    public void error(String message) {
        this.errorLogger.logMessage(Level.ERROR, null, FQCN, null, (Message)new SimpleMessage(message), null);
    }

    public void error(String message, Throwable t) {
        this.errorLogger.logMessage(Level.ERROR, null, FQCN, null, (Message)new SimpleMessage(message), t);
    }

    public void warn(String message) {
        this.errorLogger.logMessage(Level.WARN, null, FQCN, null, (Message)new SimpleMessage(message), null);
    }

    public void warn(String message, Throwable t) {
        this.errorLogger.logMessage(Level.WARN, null, FQCN, null, (Message)new SimpleMessage(message), t);
    }

    public void debug(String message) {
        this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage(message), null);
    }

    public void debug(String message, Throwable t) {
        this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage(message), t);
    }

    public void trace(String message) {
        this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage(message), null);
    }

    protected String getMethodname(int pos) {
        Object methodname = "<unknown>";
        Throwable t = new Throwable();
        StackTraceElement[] stacktrace = t.getStackTrace();
        try {
            String classname = stacktrace[pos].getClassName();
            classname = classname.substring(classname.lastIndexOf(46) + 1);
            methodname = classname + "." + stacktrace[pos].getMethodName();
        }
        catch (IndexOutOfBoundsException ioobe) {
            methodname = "<unknown>";
        }
        return methodname;
    }

    public void traceEnter() {
        this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage("ENTER " + this.getMethodname(2)), null);
    }

    public void traceExit() {
        this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage("ENTER " + this.getMethodname(2)), null);
    }

    public void traceRawVermeerParameter(VermeerRequest request, String parameterName) {
        String data = request.getParameter(parameterName);
        if (data == null) {
            this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage(this.getMethodname(2) + ": Parameter \"" + parameterName + "\" is empty."), null);
        } else {
            this.errorLogger.logMessage(Level.DEBUG, null, FQCN, null, (Message)new SimpleMessage(this.getMethodname(2) + ": Parameter \"" + parameterName + "\" contains raw data: " + data), null);
        }
    }

    public void traceReturnList(VermeerReturnList items) {
        this.nestedTraceReturnList(items, 0);
    }

    protected void nestedTraceReturnList(VermeerReturnList items, int depth) {
        int i;
        StringBuffer spacer = new StringBuffer();
        for (i = 0; i < depth; ++i) {
            spacer.append("  ");
        }
        for (i = 0; i < items.size(); ++i) {
            int ii;
            StringBuffer sb = new StringBuffer();
            sb.append(spacer);
            sb.append("[");
            sb.append(Integer.toString(i));
            sb.append("] ");
            sb.append(items.getName(i));
            sb.append("=");
            VermeerReturnValue value = items.getValue(i);
            if (value instanceof VermeerReturnList) {
                sb.append("<LIST>");
                this.trace(sb.toString());
                this.nestedTraceReturnList((VermeerReturnList)value, depth + 1);
                continue;
            }
            if (value instanceof VermeerReturnDocumentList) {
                sb.append("<DOCUMENT-LIST>");
                this.trace(sb.toString());
                for (ii = 0; ii < ((VermeerReturnDocumentList)value).size(); ++ii) {
                    sb = new StringBuffer();
                    sb.append(spacer);
                    sb.append("  ");
                    sb.append("[");
                    sb.append(Integer.toString(ii));
                    sb.append("] ");
                    sb.append(((VermeerReturnDocumentList)value).getDocumentName(ii));
                    sb.append("=");
                    sb.append(((VermeerReturnDocumentList)value).getMetainfoDictionary(ii).toTraceString());
                    this.trace(sb.toString());
                }
                continue;
            }
            if (value instanceof VermeerReturnVectorUrlDirectory) {
                sb.append("<VECTOR-URL>");
                this.trace(sb.toString());
                for (ii = 0; ii < ((VermeerReturnVectorUrlDirectory)value).size(); ++ii) {
                    sb = new StringBuffer();
                    sb.append(spacer);
                    sb.append("  ");
                    sb.append("[");
                    sb.append(Integer.toString(ii));
                    sb.append("] ");
                    sb.append(((VermeerReturnVectorUrlDirectory)value).getUrl(ii));
                    sb.append("=");
                    sb.append(((VermeerReturnVectorUrlDirectory)value).getMetainfoDictionary(ii).toTraceString());
                    this.trace(sb.toString());
                }
                continue;
            }
            sb.append(value.toTraceString());
            this.trace(sb.toString());
        }
    }
}

