/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.alfresco.officeservices.IndividualResponseRuntimeException;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.exceptions.AccessDeniedException;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.VermeerProtocolVersion;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerResponse;

public abstract class AbstractVermeerService
extends HttpServlet {
    private static final long serialVersionUID = -3147125724166350976L;
    private static final ServiceLogger logger = new ServiceLogger(AbstractVermeerService.class);
    private VermeerProtocolVersion serverProtocolVersion = new VermeerProtocolVersion(15, 0, 0, 4420);
    public static final String HEADER_NAME_VERMEER_CONTENT_TYPE = "X-Vermeer-Content-Type";
    public static final String HEADER_VALUE_VERMEER_CONTENT_TYPE = "application/x-www-form-urlencoded";

    public void setServerProtocolVersion(VermeerProtocolVersion serverProtocolVersion) {
        this.serverProtocolVersion = serverProtocolVersion;
    }

    public abstract void vermeerService(String var1, VermeerRequest var2, VermeerResponse var3) throws IOException, VermeerException, AuthenticationRequiredException, AccessDeniedException;

    public abstract UserData negotiateAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void requestAuthentication(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public abstract void invalidateAuthentication(UserData var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;

    protected String getSitePrefix(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString + request.getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserData userData;
        if (logger.isTraceEnabled()) {
            logger.traceEnter();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("doPost: negogiating authentication");
        }
        if ((userData = this.negotiateAuthentication(request, response)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("doPost: authentication negogiation requested immediate return.");
            }
            if (logger.isTraceEnabled()) {
                logger.traceExit();
            }
            return;
        }
        try {
            String vermeerContentType = request.getHeader(HEADER_NAME_VERMEER_CONTENT_TYPE);
            if (vermeerContentType == null || !vermeerContentType.equals(HEADER_VALUE_VERMEER_CONTENT_TYPE)) {
                logger.error("doPost: invalid request Content-Type.");
                response.sendError(400);
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            VermeerRequest vermeerRequest = new VermeerRequest(userData, request, this.serverProtocolVersion);
            VermeerResponse vermeerResponse = new VermeerResponse(vermeerRequest, response);
            String methodName = vermeerRequest.getMethodName();
            if (methodName == null) {
                logger.error("doPost: method key in request missing.");
                vermeerResponse.error("Method key missing.");
                if (logger.isTraceEnabled()) {
                    logger.traceExit();
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("doPost: called RPC method name is \"" + methodName + "\"");
            }
            try {
                this.vermeerService(methodName, vermeerRequest, vermeerResponse);
            }
            catch (VermeerException ve) {
                logger.error("doPost: Exception while executing vermeerService.", ve);
                try {
                    vermeerResponse.error(ve);
                }
                catch (Exception e2) {
                    logger.error("doPost: Follow-Up Exception while reporting error state.", e2);
                }
            }
            catch (IndividualResponseRuntimeException irre) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost: vermeerService requested individual error message.");
                }
                try {
                    vermeerResponse.error(irre.getFpseStatusCode(), irre.getFpseOsStatusCode(), irre.getFpseMessage());
                }
                catch (Exception e2) {
                    logger.error("doPost: Follow-Up Exception while reporting error state.", e2);
                }
            }
            catch (AuthenticationRequiredException are) {
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost: vermeerService requested authentication.");
                }
                this.requestAuthentication(request, response);
            }
            catch (Exception e) {
                this.handleUnexpectedException(e, vermeerRequest, vermeerResponse);
            }
        }
        finally {
            this.invalidateAuthentication(userData, request, response);
        }
        if (logger.isTraceEnabled()) {
            logger.traceExit();
        }
    }

    protected void handleUnexpectedException(Exception e, VermeerRequest vermeerRequest, VermeerResponse vermeerResponse) {
        logger.error("doPost: Unexpected Exception while handling request.", e);
        try {
            vermeerResponse.error("Unexpected Exception while handling request");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

