/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.module.aosmodule.service.AuthenticationServiceUserData;
import org.alfresco.module.aosmodule.service.BufferedHttpServletRequest;
import org.alfresco.module.aosmodule.vfs.AlfrescoVirtualFileSystem;
import org.alfresco.module.aosmodule.vfs.DocumentNode;
import org.alfresco.module.aosmodule.vfs.FolderNode;
import org.alfresco.module.aosmodule.vfs.VersionNumber;
import org.alfresco.officeservices.StandardWebdavService;
import org.alfresco.officeservices.URLEncoder;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.datamodel.Guid;
import org.alfresco.officeservices.exceptions.AuthenticationRequiredException;
import org.alfresco.officeservices.lists.CheckinType;
import org.alfresco.officeservices.protocol.HtmlEncoder;
import org.alfresco.officeservices.vfs.VFSDocumentNode;
import org.alfresco.officeservices.vfs.VFSNode;
import org.alfresco.officeservices.vfs.VirtualFileSystem;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebdavService
extends StandardWebdavService {
    private static final long serialVersionUID = 5535102938681050458L;
    protected VirtualFileSystem vfs;
    protected AuthenticationService authenticationService;
    protected MimetypeService mimetypeService;
    protected TransactionService transactionService;
    private long webdavSizeLimit = -1L;
    protected Logger logger = LoggerFactory.getLogger(WebdavService.class);
    protected static Map<String, String> protocolHandler = WebdavService.buildProtocolHandlerMap();
    private final Marker fatal = MarkerFactory.getMarker((String)"FATAL");
    protected static URLEncoder urlSegmentEncoder = new URLEncoder(URLEncoder.ALPHANUMERIC);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        if (wac == null) {
            throw new ServletException("Error initializing Servlet. No WebApplicationContext available.");
        }
        this.vfs = (VirtualFileSystem)wac.getBean("AosVirtualFileSystem");
        if (this.vfs == null) {
            throw new ServletException("Cannot find bean AosVirtualFileSystem in WebApplicationContext.");
        }
        ((AlfrescoVirtualFileSystem)this.vfs).prepare();
        this.authenticationService = (AuthenticationService)wac.getBean("AuthenticationService");
        if (this.authenticationService == null) {
            throw new ServletException("Cannot find bean AuthenticationService in WebApplicationContext.");
        }
        this.mimetypeService = (MimetypeService)wac.getBean("MimetypeService");
        if (this.mimetypeService == null) {
            throw new ServletException("Cannot find bean MimetypeService in WebApplicationContext.");
        }
        this.transactionService = ((AlfrescoVirtualFileSystem)this.vfs).getTransactionService();
        this.webdavSizeLimit = ((AlfrescoVirtualFileSystem)this.vfs).getWebDavHelper().getSizeLimit();
    }

    protected void handleUnexpectedException(String methodName, Exception e, HttpServletRequest req, HttpServletResponse resp) {
        AlfrescoVirtualFileSystem.checkForRetryingException(e);
        super.handleUnexpectedException(methodName, e, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        final String methodname = req.getMethod();
        final long debugId = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("------------------------------< WebDAV: " + req.getMethod() + " >------------------------------");
        }
        final BufferedHttpServletRequest bufferedRequest = req instanceof BufferedHttpServletRequest ? (BufferedHttpServletRequest)req : new BufferedHttpServletRequest(req, this.webdavSizeLimit);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    UserTransaction txn;
                    if (WebdavService.this.logger.isDebugEnabled()) {
                        WebdavService.this.logger.debug("In Retrying transaction: " + methodname + " " + debugId);
                    }
                    bufferedRequest.refresh();
                    WebdavService.super.service((HttpServletRequest)bufferedRequest, resp);
                    int responseStatus = resp.getStatus();
                    if ((responseStatus < 200 || responseStatus >= 300) && (txn = WebdavService.this.transactionService.getNonPropagatingUserTransaction()).getStatus() != 6) {
                        txn.setRollbackOnly();
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            this.logger.debug("Error in transaction", t);
            try {
                resp.setStatus(500);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            bufferedRequest.cleanup();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finished WebDAV: " + req.getMethod());
        }
    }

    protected String preProcessRequestedPath(String requestedPath) {
        if (requestedPath.equals("/aos")) {
            return "";
        }
        if (requestedPath.startsWith("/aos/")) {
            return requestedPath.substring("/aos".length());
        }
        this.logger.warn("The requestedPath sent to the webdav servlet does not start with the expected webdav mapping '/aos'. Please make sure that the mapping in web.xml corresponds to the WEBDAV_MAPPING_IN_CONTEXT constant.");
        return requestedPath;
    }

    public VirtualFileSystem getVirtualFileSystem(UserData userData) throws AuthenticationRequiredException {
        return this.vfs;
    }

    protected String getSitePrefix(HttpServletRequest request) {
        return ((AlfrescoVirtualFileSystem)this.vfs).getSitePrefix(request);
    }

    protected String getContextRootUrl(HttpServletRequest request) {
        return this.getSitePrefix(request);
    }

    protected String getEtagForNode(VFSNode node, String sitePrefix, String path) {
        try {
            if (node instanceof DocumentNode) {
                Guid guid = Guid.parse((String)((DocumentNode)node).getFileInfo().getNodeRef().getId());
                return "\"" + guid.toString() + "," + Integer.toString(((DocumentNode)node).getDateLastModified(513).hashCode()) + "\"";
            }
            if (node instanceof FolderNode) {
                Guid guid = Guid.parse((String)((FolderNode)node).getFileInfo().getNodeRef().getId());
                return "\"" + guid.toString() + ",0\"";
            }
        }
        catch (Exception e) {
            this.logger.debug("Error generating Etag for node", (Throwable)e);
        }
        return "\"{" + this.getGuidForNode(node, sitePrefix, path) + "},0\"";
    }

    protected String getResourceTagForNode(VFSNode node, String sitePrefix, String path) {
        try {
            if (node instanceof DocumentNode) {
                Guid guid = Guid.parse((String)((DocumentNode)node).getFileInfo().getNodeRef().getId());
                VersionNumber ver = ((DocumentNode)node).getVersionNumber();
                Object versionMarker = Integer.toString(ver.getMinor());
                while (((String)versionMarker).length() < 6) {
                    versionMarker = "0" + (String)versionMarker;
                }
                versionMarker = Integer.toString(ver.getMajor()) + (String)versionMarker;
                while (((String)versionMarker).length() < 11) {
                    versionMarker = "0" + (String)versionMarker;
                }
                return "rt:" + guid.toString() + "@" + (String)versionMarker;
            }
            if (node instanceof FolderNode) {
                Guid guid = Guid.parse((String)((FolderNode)node).getFileInfo().getNodeRef().getId());
                return "rt:" + guid.toString() + "@00000000000";
            }
        }
        catch (Exception e) {
            this.logger.debug("Error generating Etag for node", (Throwable)e);
        }
        return "rt:" + this.getGuidForNode(node, sitePrefix, path) + "@00000000000";
    }

    protected boolean handleNonDocumentVFSNodes(UserData userData, VFSNode node, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String userAgent;
        Object relativePath;
        boolean debugMode = this.detectDebugMode(req, resp);
        if (debugMode && this.performAction(userData, node, req, resp)) {
            return true;
        }
        String pathInfo = req.getPathInfo();
        Object path = req.getServletPath();
        if (pathInfo != null) {
            path = (String)path + pathInfo;
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        Object object = relativePath = pathInfo == null ? "/" : pathInfo;
        if (!((String)relativePath).endsWith("/")) {
            relativePath = (String)relativePath + "/";
        }
        if ((userAgent = req.getHeader("User-Agent")) != null && userAgent.indexOf("MSIE") >= 0 && (userAgent.indexOf("ms-office") >= 0 || userAgent.indexOf("MSOffice") >= 0)) {
            resp.setStatus(404);
            this.logger.error("Blocked a directory listing request from MS-Office. This indicates a broken MS-Office deployment. Please check that the ROOT and the _vti_bin webapps are deployed properly and reachable from the outside!");
        }
        String baseUrl = this.getSitePrefix(req) + urlEncoder.encode((String)relativePath);
        List subnodes = node.getEnumerableContainees(userData, 513);
        resp.setContentType("text/html;charset=utf-8");
        PrintWriter out = resp.getWriter();
        out.print("<!DOCTYPE html>\n");
        out.print("<html>\n");
        out.print("<head>\n");
        out.print("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=8\" />\n");
        out.print("<title>Alfresco Directory Listing for ");
        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer((String)relativePath));
        out.print("</title>\n");
        out.print("<style>");
        out.print("<!-- BODY {font-family:Tahoma,Arial,sans-serif; color:black; background-color:white;} H2 {margin-bottom:5px;} A {text-decoration:none;color:blue;} A:visited {text-decoration:none;color:blue;} A:hover {text-decoration:none;color:red;} .listTable { border-spacing: 1px 3px; font-size: 10pt; margin-bottom: 15px; } .listHeader { background-color: #333377; color: #FFFFFF; font-size: 10pt; } .listEven { background-color: #eeeeee; font-size: 10pt; } .listOdd { background-color: #dddddd; font-size: 10pt; } -->");
        out.print("</style>\n");
        if (debugMode) {
            this.writeJavaScript(out);
        }
        out.print("</head>\n");
        out.print("<body>\n");
        out.print("<h2>");
        StringBuffer buildUrl = new StringBuffer(this.getSitePrefix(req));
        out.print("<a href=\"");
        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)buildUrl);
        out.print("\">");
        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)buildUrl);
        out.print("</a>");
        String x = ((String)relativePath).substring(1);
        if (x.length() > 0) {
            String[] pathSegments;
            for (String segment : pathSegments = x.split("/")) {
                buildUrl.append('/');
                buildUrl.append(segment);
                out.print("/");
                out.print("<a href=\"");
                HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)buildUrl);
                out.print("\">");
                HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(segment));
                out.print("</a>");
            }
        }
        out.print("/");
        out.print("</h2>\n");
        out.print("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\" class=\"listTable\">\n");
        out.print("<tr class=\"listHeader\" >\n");
        out.print("<th align=\"left\" width=\"99%\" style=\"min-width: 100px;\">Name</th>\n");
        out.print("<th align=\"right\" style=\"min-width: 75px;\">Size</th>\n");
        if (!debugMode) {
            out.print("<th align=\"left\" style=\"min-width: 250px;\">Type</th>\n");
        }
        out.print("<th align=\"left\" style=\"min-width: 200px;\">Modified</th>\n");
        if (debugMode) {
            out.print("<th align=\"left\" style=\"min-width: 250px;\">Locked</th>\n");
            out.print("<th align=\"left\" style=\"min-width: 250px;\">Checked Out</th>\n");
            out.print("<th align=\"left\" style=\"min-width: 175px;\">Actions</th>\n");
        }
        out.print("</tr>\n");
        boolean oddEvenFlag = false;
        for (int i = 0; i < subnodes.size(); ++i) {
            String handler;
            out.print("<tr class=\"");
            out.print(oddEvenFlag ? "listOdd" : "listEven");
            oddEvenFlag = !oddEvenFlag;
            out.print("\">\n");
            out.print("<td align=\"left\">");
            VFSNode n = (VFSNode)subnodes.get(i);
            out.print("<a href=\"");
            String nodeName = n.getName(513);
            HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(baseUrl + urlEncoder.encode(nodeName)));
            out.print("\">");
            HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(nodeName));
            out.print("</a>");
            if (debugMode && n instanceof VFSDocumentNode && (handler = WebdavService.getProtocolHandler(nodeName)) != null) {
                out.print(" <a href=\"");
                out.print(handler);
                out.print(":ofe%7Cu%7C");
                HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(baseUrl + urlEncoder.encode(nodeName)));
                out.print("\">[Edit]</a>");
            }
            out.print("</td>\n");
            if (n instanceof VFSDocumentNode) {
                DocumentNode doc = (DocumentNode)n;
                doc.setIgnoreCurrentUser(true);
                out.print("<td align=\"right\">");
                out.print(doc.getSize(516));
                out.print("</td>\n");
                if (!debugMode) {
                    String displayType = (String)this.mimetypeService.getDisplaysByMimetype().get(doc.getMimeString(516));
                    if (displayType != null) {
                        out.print("<td align=\"left\">");
                        out.print(displayType);
                        out.print("</td>\n");
                    } else {
                        out.print("<td align=\"left\">&nbsp;</td>\n");
                    }
                }
                out.print("<td align=\"left\">");
                out.print(doc.getDateLastModified(516));
                out.print("</td>\n");
                if (debugMode) {
                    out.print("<td align=\"left\">");
                    if (doc.isLocked()) {
                        out.print("until ");
                        Date expiry = doc.getLockExpiry();
                        out.print(expiry == null ? "unknown" : expiry);
                        out.print(" by ");
                        String lockOwner = doc.getLockOwner();
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(lockOwner == null ? "unknown" : lockOwner));
                    }
                    out.print("</td>\n");
                    out.print("<td align=\"left\">");
                    if (doc.isCheckedOut()) {
                        Date checkoutDate = doc.getCheckoutDate();
                        out.print(checkoutDate == null ? "unknown" : checkoutDate);
                        if (doc.isCheckedOutToLocal()) {
                            out.print(" to local");
                        }
                        out.print(" by ");
                        String checkoutOwner = doc.getCheckoutOwner();
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)new StringBuffer(checkoutOwner == null ? "unknown" : checkoutOwner));
                    }
                    out.print("</td>\n");
                    out.print("<td align=\"left\">");
                    if (doc.isLocked()) {
                        out.print("<a href=\"");
                        StringBuffer unlockCommand = new StringBuffer("?cmd=unlock&item=");
                        unlockCommand.append(urlSegmentEncoder.encode(n.getName(513)));
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)unlockCommand);
                        out.print("\">Unlock</a>");
                    } else {
                        out.print("<a href=\"");
                        StringBuffer lockCommand = new StringBuffer("?cmd=lock&item=");
                        lockCommand.append(urlSegmentEncoder.encode(n.getName(513)));
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)lockCommand);
                        out.print("\">Lock</a>");
                    }
                    out.print(" ");
                    if (doc.isCheckedOut()) {
                        out.print("<a href=\"");
                        StringBuffer checkinCommand = new StringBuffer("?cmd=checkin&item=");
                        checkinCommand.append(urlSegmentEncoder.encode(n.getName(513)));
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)checkinCommand);
                        out.print("\">Checkin</a>");
                        out.print(" ");
                        out.print("<a href=\"");
                        StringBuffer uncheckoutCommand = new StringBuffer("?cmd=uncheckout&item=");
                        uncheckoutCommand.append(urlSegmentEncoder.encode(n.getName(513)));
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)uncheckoutCommand);
                        out.print("\">Uncheckout</a>");
                    } else {
                        out.print("<a href=\"");
                        StringBuffer checkoutCommand = new StringBuffer("?cmd=checkout&item=");
                        checkoutCommand.append(urlSegmentEncoder.encode(n.getName(513)));
                        HtmlEncoder.writeEncoded((Writer)out, (StringBuffer)checkoutCommand);
                        out.print("\">Checkout</a>");
                    }
                    out.print("</td>\n");
                }
            } else {
                out.print("<td align=\"right\">&lt;SUB-DIR&gt;</td>\n");
                if (!debugMode) {
                    out.print("<td align=\"left\">&nbsp;</td>\n");
                }
                out.print("<td align=\"left\">&nbsp;</td>\n");
                if (debugMode) {
                    out.print("<td align=\"left\">&nbsp;</td>\n");
                    out.print("<td align=\"left\">&nbsp;</td>\n");
                    out.print("<td align=\"left\">&nbsp;</td>\n");
                }
            }
            out.print("</tr>\n");
        }
        out.print("</table>\n");
        if (debugMode) {
            out.print("Open this folder in ");
            out.print(" <a href=\"");
            out.print("javascript:openInWindowsExplorer('" + baseUrl + "')");
            out.print("\">Windows Explorer</a>");
            out.print("\n<br/>\n");
        }
        out.print("</body>\n");
        out.print("</html>\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJavaScript(PrintWriter out) {
        block6: {
            out.print("<script type=\"text/javascript\">\n");
            try {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("alfresco/module/aos-module/templates/WebdavPageJavascript.template");
                if (is == null) break block6;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        out.println(line);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                this.logger.error(this.fatal, "Error loading ContentTypes.properties file!", (Throwable)e);
            }
        }
        out.print("</script>\n");
    }

    protected boolean detectDebugMode(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean debugMode = false;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("aosDebugMode")) continue;
                debugMode = cookie.getValue() != null && cookie.getValue().equals("1");
            }
        }
        if (debugMode) {
            if (req.getParameter("nodebug") != null) {
                debugMode = false;
                debugModeCookie = new Cookie("aosDebugMode", "0");
                debugModeCookie.setPath(req.getContextPath());
                resp.addCookie(debugModeCookie);
            }
        } else if (req.getParameter("debug") != null) {
            debugMode = true;
            debugModeCookie = new Cookie("aosDebugMode", "1");
            debugModeCookie.setPath(req.getContextPath());
            resp.addCookie(debugModeCookie);
        }
        return debugMode;
    }

    protected boolean performAction(UserData userData, VFSNode node, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        String item = req.getParameter("item");
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        if ("iqy".equalsIgnoreCase(cmd)) {
            String list = req.getParameter("list");
            if (list == null || list.length() == 0) {
                return false;
            }
            resp.setContentType("text/x-ms-iqy");
            PrintWriter out = resp.getWriter();
            out.print("WEB\n");
            out.print("1\n");
            out.print(this.getSitePrefix(req) + "/_vti_bin/owssvr.dll?XMLDATA=1&List=" + urlSegmentEncoder.encode(list) + "&View={00000000-0000-0000-0000-000000000000}&RowLimit=0\n");
            out.print("\n");
            out.print("Selection={00000000-0000-0000-0000-000000000000}-{11111111-1111-1111-1111-111111111111}\n");
            out.print("EditWebPage=\n");
            out.print("Formatting=None\n");
            out.print("PreFormattedTextToColumns=True\n");
            out.print("ConsecutiveDelimitersAsOne=True\n");
            out.print("SingleBlockTextImport=False\n");
            out.print("DisableDateRecognition=False\n");
            out.print("DisableRedirections=False\n");
            out.print("SharePointApplication=" + this.getSitePrefix(req) + "/_vti_bin\n");
            out.print("SharePointListView={00000000-0000-0000-0000-000000000000}\n");
            out.print("SharePointListName=" + list + "\n");
            return true;
        }
        if (item == null || item.length() == 0) {
            return false;
        }
        VFSNode itemNode = node.getContainmentByName(userData, item, 516);
        if (itemNode == null || !(itemNode instanceof VFSDocumentNode)) {
            return false;
        }
        VFSDocumentNode itemDocument = (VFSDocumentNode)itemNode;
        if (cmd.equalsIgnoreCase("checkout")) {
            itemDocument.checkout(0, null, 0);
        }
        if (cmd.equalsIgnoreCase("uncheckout")) {
            itemDocument.uncheckout(false, 0);
        }
        if (cmd.equalsIgnoreCase("checkin")) {
            itemDocument.checkin("", false, 0, CheckinType.MAJOR);
        }
        if (cmd.equalsIgnoreCase("lock")) {
            itemDocument.checkout(10, null, 0);
        }
        if (cmd.equalsIgnoreCase("unlock")) {
            itemDocument.uncheckout(true, 0);
        }
        return false;
    }

    protected String generateStsSyncUrl(String type, String weburl, String listurl, String guid, String siteName, String listName, String folderUrl, String folderId) {
        StringBuffer link = new StringBuffer();
        link.append("stssync://sts/");
        link.append("?ver=1.1");
        link.append("&type=");
        link.append(urlSegmentEncoder.encode(type));
        link.append("&cmd=add-folder");
        link.append("&base-url=");
        link.append(urlSegmentEncoder.encode(weburl));
        link.append("&list-url=");
        link.append(urlSegmentEncoder.encode(listurl));
        link.append("&guid=");
        link.append(urlSegmentEncoder.encode(guid));
        link.append("&site-name=");
        link.append(urlSegmentEncoder.encode(siteName));
        link.append("&list-name=");
        link.append(urlSegmentEncoder.encode(listName));
        if (folderUrl != null && folderId != null) {
            link.append("&folder-url=");
            link.append(urlSegmentEncoder.encode(folderUrl));
            link.append("&folder-id=");
            link.append(urlSegmentEncoder.encode(folderId));
        }
        return link.toString();
    }

    protected String getServerUrl(HttpServletRequest request) {
        String protocol = request.isSecure() ? "https://" : "http://";
        int defaultPort = request.isSecure() ? 443 : 80;
        String portString = request.getLocalPort() != defaultPort ? ":" + Integer.toString(request.getLocalPort()) : "";
        return protocol + request.getServerName() + portString;
    }

    protected static String getProtocolHandler(String fileName) {
        int extPos = fileName.lastIndexOf(46);
        if (extPos < 0) {
            return null;
        }
        return protocolHandler.get(fileName.substring(extPos));
    }

    protected static Map<String, String> buildProtocolHandlerMap() {
        HashMap<String, String> result = new HashMap<String, String>(40);
        result.put(".doc", "ms-word");
        result.put(".docx", "ms-word");
        result.put(".docm", "ms-word");
        result.put(".dot", "ms-word");
        result.put(".dotx", "ms-word");
        result.put(".dotm", "ms-word");
        result.put(".xls", "ms-excel");
        result.put(".xlsx", "ms-excel");
        result.put(".xlsb", "ms-excel");
        result.put(".xlsm", "ms-excel");
        result.put(".xlt", "ms-excel");
        result.put(".xltx", "ms-excel");
        result.put(".xltm", "ms-excel");
        result.put(".xlam", "ms-excel");
        result.put(".ppt", "ms-powerpoint");
        result.put(".pptx", "ms-powerpoint");
        result.put(".pot", "ms-powerpoint");
        result.put(".potx", "ms-powerpoint");
        result.put(".potm", "ms-powerpoint");
        result.put(".pptm", "ms-powerpoint");
        result.put(".potm", "ms-powerpoint");
        result.put(".pps", "ms-powerpoint");
        result.put(".ppsx", "ms-powerpoint");
        result.put(".ppam", "ms-powerpoint");
        result.put(".ppsm", "ms-powerpoint");
        result.put(".sldx", "ms-powerpoint");
        result.put(".sldm", "ms-powerpoint");
        result.put(".rtf", "ms-word");
        result.put(".vsd", "ms-visio");
        result.put(".vsdx", "ms-visio");
        result.put(".vsdm", "ms-visio");
        result.put(".vss", "ms-visio");
        result.put(".vssx", "ms-visio");
        result.put(".vssm", "ms-visio");
        result.put(".vst", "ms-visio");
        result.put(".vstx", "ms-visio");
        result.put(".vstm", "ms-visio");
        result.put(".mpp", "ms-project");
        result.put(".mpt", "ms-project");
        return result;
    }

    public UserData negotiateAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return new AuthenticationServiceUserData(this.authenticationService);
    }

    public void requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public void invalidateAuthentication(UserData userData, HttpServletRequest request, HttpServletResponse response) throws IOException {
    }
}

