/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.module.aosmodule.metadata.ContentFilter;
import org.alfresco.module.aosmodule.metadata.IOContentFilterRegistry;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;

public class StandardIOContentFilterRegistry
implements IOContentFilterRegistry {
    protected List<ContentFilter> inputFilters = new LinkedList<ContentFilter>();
    protected List<ContentFilter> outputFilters = new LinkedList<ContentFilter>();

    @Override
    public ContentFilter getInputFilter(String mimeType, PushbackInputStream pis, NodeRef nodeRef) throws IOException {
        for (ContentFilter filter : this.inputFilters) {
            if (!filter.appliesToInput(mimeType, pis, nodeRef)) continue;
            return filter;
        }
        return null;
    }

    @Override
    public ContentFilter getOutputFilter(NodeRef nodeRef, ContentReader contentReader) {
        for (ContentFilter filter : this.outputFilters) {
            if (!filter.appliesToOutput(nodeRef, contentReader)) continue;
            return filter;
        }
        return null;
    }

    @Override
    public void registerInputFilter(ContentFilter contentFilter) {
        if (contentFilter != null) {
            this.inputFilters.add(contentFilter);
        }
    }

    @Override
    public void registerOutputFilter(ContentFilter contentFilter) {
        if (contentFilter != null) {
            this.outputFilters.add(contentFilter);
        }
    }

    @Override
    public int getMaxInputPreviewByteCount() {
        int result = 0;
        for (ContentFilter filter : this.inputFilters) {
            result = Math.max(result, filter.getMaxInputPreviewByteCount());
        }
        return result;
    }
}

