/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.aosmodule.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.List;
import org.alfresco.module.aosmodule.metadata.AbstractContentFilter;
import org.alfresco.module.aosmodule.metadata.ChainingContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.ContentFilterProcessingResult;
import org.alfresco.module.aosmodule.metadata.ContentPostProcessor;
import org.alfresco.module.aosmodule.metadata.OLEFileProcessor;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.poi.EmptyFileException;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;

public class OLEFileContentFilter
extends AbstractContentFilter {
    List<OLEFileProcessor> processors = null;

    public List<OLEFileProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(List<OLEFileProcessor> processors) {
        this.processors = processors;
    }

    @Override
    public int getMaxInputPreviewByteCount() {
        return 8;
    }

    @Override
    public boolean appliesToInput(String mimeType, PushbackInputStream pis, NodeRef nodeRef) throws IOException {
        if (this.processors == null || this.processors.size() == 0) {
            return false;
        }
        if (!super.appliesToInput(mimeType, pis, nodeRef)) {
            return false;
        }
        try {
            if (FileMagic.valueOf((byte[])IOUtils.peekFirst8Bytes((InputStream)pis)) != FileMagic.OLE2) {
                return false;
            }
        }
        catch (EmptyFileException efe) {
            return false;
        }
        for (OLEFileProcessor processor : this.processors) {
            if (!processor.appliesTo(nodeRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean appliesToOutput(NodeRef nodeRef, ContentReader contentReader) {
        if (!super.appliesToOutput(nodeRef, contentReader)) {
            return false;
        }
        if (this.processors == null || this.processors.size() == 0) {
            return false;
        }
        for (OLEFileProcessor processor : this.processors) {
            if (!processor.appliesTo(nodeRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContentFilterProcessingResult process(NodeRef nodeRef, InputStream in, OutputStream out, boolean stopOnNoOp) throws IOException {
        if (this.processors == null || this.processors.size() == 0) {
            if (stopOnNoOp || out == null) {
                return ContentFilterProcessingResult.UNMODIFIED;
            }
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)out);
            return ContentFilterProcessingResult.MODIFIED;
        }
        POIFSFileSystem oleFS = new POIFSFileSystem(in);
        boolean haveInterestedModifiers = false;
        for (OLEFileProcessor processor : this.processors) {
            haveInterestedModifiers |= processor.appliesTo(oleFS, nodeRef);
        }
        if (!haveInterestedModifiers) {
            if (stopOnNoOp || out == null) {
                return ContentFilterProcessingResult.UNMODIFIED;
            }
            oleFS.writeFilesystem(out);
            return ContentFilterProcessingResult.MODIFIED;
        }
        boolean hasModifications = false;
        ContentPostProcessor postProcessor = null;
        for (OLEFileProcessor processor : this.processors) {
            if (!processor.appliesTo(oleFS, nodeRef)) continue;
            ContentFilterProcessingResult processorResult = processor.execute(oleFS, nodeRef);
            hasModifications |= processorResult.isModified();
            if (processorResult.getPostProcessor() == null) continue;
            if (postProcessor == null) {
                postProcessor = processorResult.getPostProcessor();
                continue;
            }
            if (postProcessor instanceof ChainingContentPostProcessor) {
                ((ChainingContentPostProcessor)postProcessor).add(processorResult.getPostProcessor());
                continue;
            }
            ChainingContentPostProcessor chain = new ChainingContentPostProcessor();
            chain.add(postProcessor);
            chain.add(processorResult.getPostProcessor());
            postProcessor = chain;
        }
        if (!hasModifications && stopOnNoOp || out == null) {
            return new ContentFilterProcessingResult(false, postProcessor);
        }
        oleFS.writeFilesystem(out);
        return new ContentFilterProcessingResult(true, postProcessor);
    }
}

