/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import org.alfresco.officeservices.protocol.VermeerResponse;
import org.alfresco.officeservices.protocol.VermeerReturnDictionary;

public class VermeerReturnDictionaryService
implements VermeerReturnDictionary {
    protected String serviceName;
    protected String sitePrefix;
    protected String username;
    protected String userDomain;
    protected boolean caseSensitiveUrls = true;
    protected String serverTimezone = "+0000";
    protected String siteCollectionUrl;

    public VermeerReturnDictionaryService(String serviceName, String sitePrefix, String username, boolean caseSensitiveUrls) {
        this.serviceName = serviceName;
        this.sitePrefix = sitePrefix;
        this.username = username;
        this.userDomain = "OFFICE";
        this.caseSensitiveUrls = caseSensitiveUrls;
        this.siteCollectionUrl = serviceName;
    }

    public void setServerTimezone(String serverTz) {
        this.serverTimezone = serverTz;
    }

    public void setSiteCollectionUrl(String siteCollectionUrl) {
        this.siteCollectionUrl = siteCollectionUrl;
    }

    public VermeerReturnDictionaryService(String serviceName, String sitePrefix, String username, String userDomain, boolean caseSensitiveUrls) {
        this.serviceName = serviceName;
        this.sitePrefix = sitePrefix;
        this.username = username;
        this.userDomain = userDomain;
        this.caseSensitiveUrls = caseSensitiveUrls;
        this.siteCollectionUrl = serviceName;
    }

    @Override
    public void write(ServletOutputStream out) throws IOException {
        out.print("\n<ul>");
        out.print("\n<li>vti_defaultlanguage");
        out.print("\n<li>SW|de");
        out.print("\n<li>vti_usernames");
        out.print("\n<li>VR|");
        out.print("\n<li>vti_servercharsets");
        out.print("\n<li>VX|windows-1257 big5 windows-1252 windows-874 utf-8 windows-1251 windows-1256 euc-kr gb2312 windows-1253 windows-1258 koi8-r iso-8859-1 gb18030 iso-2022-jp ks_c_5601-1987 windows-1250 windows-1255 us-ascii euc-jp unicode unicodeFFFE windows-1254 iso-8859-2 iso-8859-15 shift_jis");
        out.print("\n<li>vti_scnoprompt");
        out.print("\n<li>IX|1");
        out.print("\n<li>vti_toolpaneurl");
        out.print("\n<li>SX|" + this.sitePrefix + "/_layouts/1031/toolpane.aspx");
        out.print("\n<li>vti_assemblyversion");
        out.print("\n<li>SX|Microsoft.SharePoint, Version&#61;11.0.0.0, Culture&#61;neutral, PublicKeyToken&#61;71e9bce111e9429c");
        out.print("\n<li>vti_webtemplate");
        out.print("\n<li>IR|1");
        out.print("\n<li>vti_custommasterurl");
        out.print("\n<li>SX|" + this.serviceName + "/_catalogs/masterpage/default.master");
        out.print("\n<li>vti_associatevisitorgroup");
        out.print("\n<li>SW|4");
        out.print("\n<li>vti_hasonetlayoutfiles");
        out.print("\n<li>BR|true");
        out.print("\n<li>vti_extenderversion");
        out.print("\n<li>SR|12.0.0.4518");
        out.print("\n<li>vti_associategroups");
        out.print("\n<li>SW|5&#59;4&#59;3&#59;6&#59;7&#59;8&#59;9&#59;10&#59;11&#59;14");
        out.print("\n<li>vti_casesensitiveurls");
        out.print("\n<li>IX|" + (this.caseSensitiveUrls ? "1" : "0"));
        out.print("\n<li>vti_longfilenames");
        out.print("\n<li>IX|1");
        out.print("\n<li>vti_htmlextensions");
        out.print("\n<li>SX|.html.htm.shtml.shtm.stm.htt.htx.asp.aspx.alx.asa.hta.htc.jsp.cfm.odc.dwt.php.phtml.php2.php3.php4");
        out.print("\n<li>vti_masterurl");
        out.print("\n<li>SX|" + this.serviceName + "/_catalogs/masterpage/default.master");
        out.print("\n<li>vti_sourcecontrolsystem");
        out.print("\n<li>SX|lw");
        out.print("\n<li>vti_username");
        out.print("\n<li>SX|");
        if (this.userDomain != null) {
            out.print(VermeerResponse.encodeString(this.userDomain));
            out.print("&#92;");
        }
        out.print(VermeerResponse.encodeString(this.username));
        out.print("\n<li>vti_approvallevels");
        out.print("\n<li>VR|Approved Rejected Pending&#92; Review");
        out.print("\n<li>vti_welcomenames");
        out.print("\n<li>VX|default.htm default.aspx");
        out.print("\n<li>vti_servertz");
        out.print("\n<li>SX|" + this.serverTimezone);
        out.print("\n<li>vti_sourcecontrolcookie");
        out.print("\n<li>SX|fp_internal");
        out.print("\n<li>vti_adminurl");
        out.print("\n<li>SX|" + this.sitePrefix + "/_layouts/1031/settings.aspx");
        out.print("\n<li>vti_sitecollectionurl");
        out.print("\n<li>SX|" + this.siteCollectionUrl);
        out.print("\n<li>vti_language");
        out.print("\n<li>IR|1033");
        out.print("\n<li>vti_showhiddenpages");
        out.print("\n<li>IW|1");
        out.print("\n<li>vti_categories");
        out.print("\n<li>VR|Category-A Category-B Category-C");
        out.print("\n<li>vti_featurelist");
        out.print("\n<li>VX|vti_RulesScript vti_ServerIndexServer vti_TimedDocEvents vti_ServiceMarkUrlDirExec vti_DocSaveToDB vti_ServiceMarkUrlDirBrowse vti_ACAll vti_ServerODBC vti_ServerASP vti_ServiceMarkUrlDirScript");
        out.print("\n<li>vti_hasfulltextsearch");
        out.print("\n<li>IX|0");
        out.print("\n<li>vti_httpdversion");
        out.print("\n<li>SX|Microsoft-IIS/6.0");
        out.print("\n<li>vti_serverlanguages");
        out.print("\n<li>VX|en-us");
        out.print("\n<li>vti_sourcecontrolproject");
        out.print("\n<li>SX|&#60;STS-based Locking&#62;");
        out.print("\n<li>vti_doclibwebviewenabled");
        out.print("\n<li>IX|1");
        out.print("\n<li>vti_disablewebdesignfeatures");
        out.print("\n<li>SX|wdfopensite");
        out.print("\n<li>vti_associateownergroup");
        out.print("\n<li>SW|3");
        out.print("\n<li>vti_associatemembergroup");
        out.print("\n<li>SW|5");
        out.print("\n</ul>");
    }

    @Override
    public String toTraceString() {
        StringBuffer sb = new StringBuffer();
        sb.append("vti_username=");
        sb.append(VermeerResponse.encodeString(this.userDomain));
        sb.append("&#92;");
        sb.append(VermeerResponse.encodeString(this.username));
        return sb.toString();
    }
}

