/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.alfresco.officeservices.ServiceLogger;
import org.alfresco.officeservices.exceptions.VermeerException;
import org.alfresco.officeservices.protocol.ResponseAlreadySentException;
import org.alfresco.officeservices.protocol.VermeerRequest;
import org.alfresco.officeservices.protocol.VermeerReturnList;
import org.alfresco.officeservices.protocol.VermeerReturnValue;

public class VermeerResponse {
    private static final ServiceLogger logger = new ServiceLogger(VermeerResponse.class);
    public static final int ERRORCODE_WRITEERROR = 131084;
    public static final int ERRORCODE_CANNOTRENAME = 131097;
    public static final int ERRORCODE_SYNTAXERROR = 262150;
    public static final int ERRORCODE_CONNECTIONCLOSED = 262155;
    protected VermeerRequest vermeerRequest;
    protected HttpServletResponse httpServletResponse;
    protected boolean responseSent = false;
    protected VermeerReturnList returnItems = new VermeerReturnList(true);
    protected static final String VERMEER_CONTENT_TYPE = "text/html; charset=utf-8";
    protected static ThreadLocal<SimpleDateFormat> threadLocalDateFormatA = new ThreadLocal();
    protected static ThreadLocal<SimpleDateFormat> threadLocalDateFormatB = new ThreadLocal();
    private static String[] vermeerMonthnames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public VermeerResponse(VermeerRequest req, HttpServletResponse resp) {
        if (req == null) {
            throw new IllegalArgumentException("VermeerResponse must not be instantiated without VermeerRequest");
        }
        if (resp == null) {
            throw new IllegalArgumentException("VermeerResponse must not be instantiated without HttpServletResponse");
        }
        this.vermeerRequest = req;
        this.httpServletResponse = resp;
    }

    public void error(String message) throws IOException {
        this.error(1, 0, message);
    }

    public void error(VermeerException ve) throws IOException {
        this.error(ve.getStatusCode(), ve.getOSStatusCode(), ve.getMessage());
    }

    public void error(int statusCode, int osStatusCode, String message) throws IOException {
        if (this.responseSent) {
            throw new ResponseAlreadySentException();
        }
        this.responseSent = true;
        this.httpServletResponse.setContentType(VERMEER_CONTENT_TYPE);
        ServletOutputStream out = this.httpServletResponse.getOutputStream();
        out.print("<html><head><title>vermeer RPC packet</title></head>\n");
        out.print("<body>\n");
        out.print("<p>method=");
        out.print(this.vermeerRequest.getMethodName() == null ? "unknown method" : this.vermeerRequest.getMethodName());
        out.print(":");
        out.print(this.vermeerRequest.getEffectiveVersion().toString());
        out.print("\n");
        out.print("<p>status=\n");
        out.print("<ul>\n");
        out.print("<li>status=" + statusCode + "\n");
        out.print("<li>osstatus=" + osStatusCode + "\n");
        out.print("<li>msg=" + (message == null || message.equals("") ? "Error" : VermeerResponse.encodeString(message)) + "\n");
        out.print("<li>osmsg=no error\n");
        out.print("</ul>\n");
        out.print("</body>\n");
        out.print("</html>\n");
    }

    public void unauthorized() throws IOException {
        if (this.responseSent) {
            throw new ResponseAlreadySentException();
        }
        this.responseSent = true;
        this.httpServletResponse.setStatus(401);
    }

    public void addReturnItem(String name, VermeerReturnValue value) {
        this.returnItems.add(name, value);
    }

    public void send() throws IOException {
        if (this.responseSent) {
            logger.error("send(): Response has already been sent.");
            throw new ResponseAlreadySentException();
        }
        this.responseSent = true;
        if (logger.isTraceEnabled()) {
            logger.trace("send(): sending return message for method " + (this.vermeerRequest.getMethodString() == null ? "unknown method" : this.vermeerRequest.getMethodString()));
            logger.traceReturnList(this.returnItems);
        }
        this.httpServletResponse.setContentType(VERMEER_CONTENT_TYPE);
        ServletOutputStream out = this.httpServletResponse.getOutputStream();
        out.print("<html><head><title>vermeer RPC packet</title></head>\n<body>\n");
        out.print("<p>method=");
        out.print(this.vermeerRequest.getMethodName() == null ? "unknown method" : this.vermeerRequest.getMethodName());
        out.print(":");
        out.print(this.vermeerRequest.getEffectiveVersion().toString());
        this.returnItems.write(out);
        out.print("\n</body>\n");
        out.print("</html>\n");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.httpServletResponse.setContentType(VERMEER_CONTENT_TYPE);
        return this.httpServletResponse.getOutputStream();
    }

    public static String encodeString(String input) {
        byte[] utf8bytes;
        if (input == null) {
            return null;
        }
        try {
            utf8bytes = input.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            utf8bytes = input.getBytes();
        }
        StringBuffer result = new StringBuffer();
        block11: for (int i = 0; i < utf8bytes.length; ++i) {
            int byteint = utf8bytes[i];
            if (byteint < 0) {
                byteint += 256;
            }
            switch (byteint) {
                case 34: {
                    result.append("&#34;");
                    continue block11;
                }
                case 38: {
                    result.append("&#38;");
                    continue block11;
                }
                case 39: {
                    result.append("&#39;");
                    continue block11;
                }
                case 60: {
                    result.append("&#60;");
                    continue block11;
                }
                case 61: {
                    result.append("&#61;");
                    continue block11;
                }
                case 62: {
                    result.append("&#62;");
                    continue block11;
                }
                case 92: {
                    result.append("&#92;");
                    continue block11;
                }
                default: {
                    if (byteint > 122) {
                        result.append("&#" + byteint + ";");
                        continue block11;
                    }
                    result.append((char)byteint);
                }
            }
        }
        return result.toString();
    }

    protected static SimpleDateFormat getThreadDateFormatA() {
        SimpleDateFormat result = threadLocalDateFormatA.get();
        if (result == null) {
            result = VermeerResponse.createUTCSimpleDateFormat("dd ");
            threadLocalDateFormatA.set(result);
        }
        return result;
    }

    protected static SimpleDateFormat getThreadDateFormatB() {
        SimpleDateFormat result = threadLocalDateFormatB.get();
        if (result == null) {
            result = VermeerResponse.createUTCSimpleDateFormat(" yyyy HH:mm:ss -0000");
            threadLocalDateFormatB.set(result);
        }
        return result;
    }

    private static SimpleDateFormat createUTCSimpleDateFormat(String pattern) {
        SimpleDateFormat result = new SimpleDateFormat(pattern);
        result.setTimeZone(TimeZone.getTimeZone("UTC"));
        return result;
    }

    public static String formatDate(Date d) {
        if (d == null) {
            d = new Date();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int month = cal.get(2);
        return VermeerResponse.getThreadDateFormatA().format(d) + vermeerMonthnames[month] + VermeerResponse.getThreadDateFormatB().format(d);
    }
}

