/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.protocol;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.officeservices.UserData;
import org.alfresco.officeservices.protocol.VermeerProtocolVersion;

public class VermeerRequest {
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected HttpServletRequest request;
    protected UserData userData;
    protected ServletInputStream inputStream;
    protected String methodString;
    protected String methodName;
    protected String methodVersion;
    private boolean fsmDone;
    private int fsmState;
    private StringBuffer fsmCurrentName;
    private byte[] fsmCurrentValue;
    private int fsmCurrentValueCapacity;
    private int fsmCurrentValueSize;
    private int subFsmState;
    private byte subFsmHexcharA;
    private byte subFsmHexcharB;
    private VermeerProtocolVersion clientVersion;
    private VermeerProtocolVersion serverVersion;
    private VermeerProtocolVersion effectiveVersion;

    public VermeerRequest(UserData userData, HttpServletRequest request, VermeerProtocolVersion serverVersion) throws IOException {
        this.userData = userData;
        this.request = request;
        this.serverVersion = serverVersion;
        this.inputStream = this.request.getInputStream();
        this.fsmCurrentName = new StringBuffer();
        this.fsmCurrentValueCapacity = 256;
        this.fsmCurrentValueSize = 0;
        this.fsmCurrentValue = new byte[256];
        this.parseParameters();
        this.methodString = this.parameters.get("method");
        this.decodeMethodString();
        try {
            this.clientVersion = VermeerProtocolVersion.valueOf(this.methodVersion);
        }
        catch (IllegalArgumentException iae) {
            this.clientVersion = this.serverVersion;
        }
        this.effectiveVersion = VermeerProtocolVersion.min(this.clientVersion, this.serverVersion);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public String getParameter(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodVersion() {
        return this.methodVersion;
    }

    public String getMethodString() {
        return this.methodString;
    }

    public String getThisServiceName() {
        return this.request.getContextPath();
    }

    public InputStream getAttachedFileInputStream() {
        return this.inputStream;
    }

    private void addCurrentValueByte(byte newbyte) {
        if (this.fsmCurrentValueSize >= this.fsmCurrentValueCapacity) {
            if (this.fsmCurrentValueCapacity >= 1024) {
                return;
            }
            int newcap = this.fsmCurrentValueCapacity + 256;
            byte[] newarray = new byte[newcap];
            System.arraycopy(this.fsmCurrentValue, 0, newarray, 0, this.fsmCurrentValueCapacity);
            this.fsmCurrentValueCapacity = newcap;
            this.fsmCurrentValue = newarray;
        }
        this.fsmCurrentValue[this.fsmCurrentValueSize] = newbyte;
        ++this.fsmCurrentValueSize;
    }

    private byte[] getCurrentValueBytes() {
        byte[] result = new byte[this.fsmCurrentValueSize];
        System.arraycopy(this.fsmCurrentValue, 0, result, 0, this.fsmCurrentValueSize);
        return result;
    }

    protected void parseParameters() throws IOException {
        int postByte;
        this.FSM_Init();
        while (!this.fsmDone && (postByte = this.inputStream.read()) != -1) {
            this.FSM_Step((byte)postByte);
        }
        this.FSM_Finalize();
    }

    private void FSM_Init() {
        this.fsmDone = false;
        this.fsmState = 0;
        this.fsmCurrentName.setLength(0);
        this.fsmCurrentValueSize = 0;
        this.subFsmState = 0;
    }

    private void FSM_Step(byte b) {
        if (b == 10) {
            this.fsmDone = true;
        } else {
            block2 : switch (this.fsmState) {
                case 0: {
                    if (b == 61) {
                        this.fsmState = 1;
                        this.subFsmState = 0;
                        break;
                    }
                    if (b == 38) {
                        try {
                            this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes(), "UTF8").replaceAll("\\\\\"", "\""));
                        }
                        catch (UnsupportedEncodingException e) {
                            this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes()).replaceAll("\\\\\"", "\""));
                        }
                        this.fsmCurrentName.setLength(0);
                        this.fsmCurrentValueSize = 0;
                        this.fsmState = 0;
                        this.subFsmState = 0;
                        break;
                    }
                    switch (this.subFsmState) {
                        default: {
                            if (b == 37) {
                                this.subFsmState = 1;
                                break block2;
                            }
                            if (b == 43) {
                                this.fsmCurrentName.append(' ');
                                break block2;
                            }
                            this.fsmCurrentName.append((char)b);
                            break block2;
                        }
                        case 1: {
                            this.subFsmHexcharA = b;
                            this.subFsmState = 2;
                            break block2;
                        }
                        case 2: 
                    }
                    this.subFsmHexcharB = b;
                    if (VermeerRequest.isHexDigit(this.subFsmHexcharA) && VermeerRequest.isHexDigit(this.subFsmHexcharB)) {
                        this.fsmCurrentName.append(VermeerRequest.decodeHexChar(this.subFsmHexcharA, this.subFsmHexcharB));
                    } else {
                        this.fsmCurrentName.append('%');
                        this.fsmCurrentName.append(this.subFsmHexcharA);
                        this.fsmCurrentName.append(this.subFsmHexcharB);
                    }
                    this.subFsmState = 0;
                    break;
                }
                case 1: {
                    if (b == 38) {
                        try {
                            this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes(), "UTF8").replaceAll("\\\\\"", "\""));
                        }
                        catch (UnsupportedEncodingException e) {
                            this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes()).replaceAll("\\\\\"", "\""));
                        }
                        this.fsmCurrentName.setLength(0);
                        this.fsmCurrentValueSize = 0;
                        this.fsmState = 0;
                        this.subFsmState = 0;
                        break;
                    }
                    switch (this.subFsmState) {
                        default: {
                            if (b == 37) {
                                this.subFsmState = 1;
                                break block2;
                            }
                            if (b == 43) {
                                this.addCurrentValueByte((byte)32);
                                break block2;
                            }
                            this.addCurrentValueByte(b);
                            break block2;
                        }
                        case 1: {
                            this.subFsmHexcharA = b;
                            this.subFsmState = 2;
                            break block2;
                        }
                        case 2: 
                    }
                    this.subFsmHexcharB = b;
                    if (VermeerRequest.isHexDigit(this.subFsmHexcharA) && VermeerRequest.isHexDigit(this.subFsmHexcharB)) {
                        this.addCurrentValueByte((byte)VermeerRequest.decodeHexChar(this.subFsmHexcharA, this.subFsmHexcharB));
                    } else {
                        this.addCurrentValueByte((byte)37);
                        this.addCurrentValueByte(this.subFsmHexcharA);
                        this.addCurrentValueByte(this.subFsmHexcharB);
                    }
                    this.subFsmState = 0;
                }
            }
        }
    }

    private void FSM_Finalize() {
        if (this.fsmCurrentName.length() > 0) {
            try {
                this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes(), "UTF8").replaceAll("\\\\\"", "\""));
            }
            catch (UnsupportedEncodingException e) {
                this.parameters.put(this.fsmCurrentName.toString(), new String(this.getCurrentValueBytes()).replaceAll("\\\\\"", "\""));
            }
        }
    }

    protected void decodeMethodString() {
        if (this.methodString == null) {
            return;
        }
        int delimPos = this.methodString.indexOf(58);
        if (delimPos >= 0) {
            this.methodVersion = delimPos < this.methodString.length() - 1 ? this.methodString.substring(delimPos + 1) : "";
            this.methodName = this.methodString.substring(0, delimPos);
        } else {
            this.methodName = this.methodString;
            this.methodVersion = "";
        }
    }

    private static boolean isHexDigit(byte test) {
        return test >= 48 && test <= 57 || test >= 65 && test <= 70 || test >= 97 && test <= 102;
    }

    private static char decodeHexChar(byte b1, byte b2) {
        if (b1 >= 97 && b1 <= 102) {
            b1 = (byte)(65 + (b1 - 97));
        }
        int result = b1 >= 65 ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        result *= 16;
        if (b2 >= 97 && b2 <= 102) {
            b2 = (byte)(65 + (b2 - 97));
        }
        return (char)(result += b2 >= 65 ? (b2 & 0xDF) - 65 + 10 : b2 - 48);
    }

    public VermeerProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    public VermeerProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public VermeerProtocolVersion getEffectiveVersion() {
        return this.effectiveVersion;
    }
}

