/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.dws;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.alfresco.officeservices.dws.DwsUpdateBatchMethod;
import org.alfresco.officeservices.dws.DwsUpdateBatchSyntaxException;
import org.alfresco.officeservices.protocol.DefaultEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DwsUpdateBatchRequest {
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected List<DwsUpdateBatchMethod> methods = new ArrayList<DwsUpdateBatchMethod>();
    public static final String BATCH_ELEMENT_ROOT = "ows:Batch";
    public static final String BATCH_ELEMENT_SETVAR = "SetVar";
    public static final String BATCH_ELEMENT_METHOD = "Method";
    public static final String BATCH_ATTRIBUTE_NAME = "Name";
    public static final String BATCH_METHOD_ATTRIBUTE_ID = "ID";
    public static final String BATCH_ELEMENT_SETLIST = "SetList";

    public DwsUpdateBatchRequest(String message) throws ParserConfigurationException, SAXException, IOException, DwsUpdateBatchSyntaxException {
        Element rootElement = DwsUpdateBatchRequest.getXmlDocumentFromString(message);
        this.parseBatch(rootElement);
    }

    public String getVar(String name) {
        return this.attributes.get(name);
    }

    public int size() {
        return this.methods.size();
    }

    public DwsUpdateBatchMethod getMethod(int index) {
        return this.methods.get(index);
    }

    protected static Element getXmlDocumentFromString(String message) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        docBuilder.setEntityResolver(new DefaultEntityResolver());
        InputSource is = new InputSource(new StringReader(message));
        Document xmlDocument = docBuilder.parse(is);
        return xmlDocument.getDocumentElement();
    }

    protected static String getTextContentsOfElement(Element e) {
        if (e == null) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node testchild = children.item(i);
            if (testchild.getNodeType() != 3) continue;
            value.append(testchild.getNodeValue());
        }
        return value.toString();
    }

    protected void parseBatch(Element rootElement) throws DwsUpdateBatchSyntaxException {
        if (!rootElement.getNodeName().equals(BATCH_ELEMENT_ROOT)) {
            throw new DwsUpdateBatchSyntaxException("The name of the root element must be ows:Batch");
        }
        NodeList childElementsList = rootElement.getChildNodes();
        for (int i = 0; i < childElementsList.getLength(); ++i) {
            Node testchild = childElementsList.item(i);
            if (testchild.getNodeType() != 1) continue;
            Element e = (Element)testchild;
            if (e.getTagName().equals(BATCH_ELEMENT_SETVAR)) {
                String name = e.getAttribute(BATCH_ATTRIBUTE_NAME);
                String value = DwsUpdateBatchRequest.getTextContentsOfElement(e);
                if (name == null || value == null) continue;
                this.attributes.put(name.toLowerCase(), value);
                continue;
            }
            if (!e.getTagName().equals(BATCH_ELEMENT_METHOD)) continue;
            String id = e.getAttribute(BATCH_METHOD_ATTRIBUTE_ID);
            String list = null;
            HashMap<String, String> vars = new HashMap<String, String>();
            NodeList methodElementsList = e.getChildNodes();
            for (int ii = 0; ii < methodElementsList.getLength(); ++ii) {
                Node methodchild = methodElementsList.item(ii);
                if (methodchild.getNodeType() != 1) continue;
                Element ee = (Element)methodchild;
                if (ee.getTagName().equals(BATCH_ELEMENT_SETVAR)) {
                    String name = ee.getAttribute(BATCH_ATTRIBUTE_NAME);
                    String value = DwsUpdateBatchRequest.getTextContentsOfElement(ee);
                    if (name == null || value == null) continue;
                    vars.put(name.toLowerCase(), value);
                    continue;
                }
                if (!ee.getTagName().equals(BATCH_ELEMENT_SETLIST)) continue;
                String listName = DwsUpdateBatchRequest.getTextContentsOfElement(ee);
                if (list == null) {
                    list = listName;
                    continue;
                }
                throw new DwsUpdateBatchSyntaxException("Multiple list name in batch.");
            }
            if (id == null || list == null) continue;
            this.methods.add(new DwsUpdateBatchMethod(id, list, vars));
        }
    }
}

