/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.datamodel;

import java.util.regex.Pattern;

public final class Guid {
    private String guid;
    private static final Pattern GUID_PATTERN = Pattern.compile("\\A\\{[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\}\\z");
    private static final Pattern INNER_GUID_PATTERN = Pattern.compile("\\A[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}\\z");
    private static final Pattern CONDENSED_GUID_PATTERN = Pattern.compile("\\A[a-fA-F0-9]{32}\\z");

    private Guid(String guid, boolean enforceUpperCase) {
        this.guid = enforceUpperCase ? guid.toUpperCase() : guid;
    }

    public static Guid parse(String in) {
        return Guid.parse(in, true);
    }

    public static Guid parse(String in, boolean enforceUpperCase) {
        if (GUID_PATTERN.matcher(in).matches()) {
            return new Guid(in, enforceUpperCase);
        }
        if (INNER_GUID_PATTERN.matcher(in).matches()) {
            return new Guid(Guid.expandInnerGuid(in), enforceUpperCase);
        }
        if (CONDENSED_GUID_PATTERN.matcher(in).matches()) {
            return new Guid(Guid.expandCondensedGuid(in), enforceUpperCase);
        }
        throw new IllegalArgumentException("'" + in + "' is not a valid GUID");
    }

    public String toString() {
        return this.guid;
    }

    public boolean equals(Object obj) {
        return obj instanceof Guid && ((Guid)obj).guid.equalsIgnoreCase(this.guid);
    }

    public String toInnerString() {
        return this.guid.substring(1, 37);
    }

    public String toCondensedString() {
        return this.guid.substring(1, 9) + this.guid.substring(10, 14) + this.guid.substring(15, 19) + this.guid.substring(20, 24) + this.guid.substring(25, 37);
    }

    private static String expandInnerGuid(String inner) {
        return "{" + inner + "}";
    }

    private static String expandCondensedGuid(String compressed) {
        return "{" + compressed.substring(0, 8) + "-" + compressed.substring(8, 12) + "-" + compressed.substring(12, 16) + "-" + compressed.substring(16, 20) + "-" + compressed.substring(20) + "}";
    }
}

