/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.officeservices.docproc;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.alfresco.officeservices.docproc.DocumentPropertyDataType;
import org.alfresco.officeservices.docproc.DocumentPropertyDateFormat;
import org.alfresco.officeservices.docproc.DocumentPropertyOrigin;
import org.alfresco.officeservices.docproc.PropertyFormat;

public class DocumentProperty {
    private String name;
    private String displayName;
    private String description;
    private DocumentPropertyDataType dataType;
    private DocumentPropertyOrigin origin;
    private boolean mandatory;
    private boolean readOnly;
    private Object value;
    private Integer minTextLength;
    private Integer maxTextLength;
    private Number minValue;
    private Number maxValue;
    private int decimals;
    private Iterable<String> choices;
    private DocumentPropertyDateFormat dateFormat;
    private boolean multilineText;

    private DocumentProperty(String name, String displayName, String description, DocumentPropertyDataType dataType, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, Object value, Integer minTextLength, Integer maxTextLength, Number minValue, Number maxValue, Iterable<String> choices, int decimals, DocumentPropertyDateFormat dateFormat, boolean multilineText) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.dataType = dataType;
        this.origin = origin;
        this.mandatory = mandatory;
        this.readOnly = readOnly;
        this.value = value;
        this.minTextLength = minTextLength;
        this.maxTextLength = maxTextLength;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.choices = choices;
        this.decimals = decimals;
        this.dateFormat = dateFormat;
        this.multilineText = multilineText;
    }

    public static DocumentProperty createTextDocumentProperty(String name, String displayName, String description, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, String value, Integer minTextLength, Integer maxTextLength, boolean multiLine) {
        return new DocumentProperty(name, displayName, description, DocumentPropertyDataType.TEXT, origin, mandatory, readOnly, value, minTextLength, maxTextLength, null, null, null, -1, null, multiLine);
    }

    public static DocumentProperty createChoiceDocumentProperty(String name, String displayName, String description, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, String value, Iterable<String> choices) {
        return new DocumentProperty(name, displayName, description, DocumentPropertyDataType.CHOICE, origin, mandatory, readOnly, value, null, null, null, null, choices, -1, null, false);
    }

    public static DocumentProperty createNumberDocumentProperty(String name, String displayName, String description, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, Number value, int decimals, Number minValue, Number maxValue) {
        return new DocumentProperty(name, displayName, description, DocumentPropertyDataType.NUMBER, origin, mandatory, readOnly, value, null, null, minValue, maxValue, null, decimals, null, false);
    }

    public static DocumentProperty createDateTimeDocumentProperty(String name, String displayName, String description, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, Date value, DocumentPropertyDateFormat dateFormat) {
        return new DocumentProperty(name, displayName, description, DocumentPropertyDataType.DATETIME, origin, mandatory, readOnly, value, null, null, null, null, null, -1, dateFormat, false);
    }

    public static DocumentProperty createBooleanDocumentProperty(String name, String displayName, String description, DocumentPropertyOrigin origin, boolean mandatory, boolean readOnly, Boolean value) {
        return new DocumentProperty(name, displayName, description, DocumentPropertyDataType.BOOLEAN, origin, mandatory, readOnly, value, null, null, null, null, null, -1, null, false);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentPropertyDataType getDataType() {
        return this.dataType;
    }

    public DocumentPropertyOrigin getOrigin() {
        return this.origin;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getMinTextLength() {
        return this.minTextLength;
    }

    public Integer getMaxTextLength() {
        return this.maxTextLength;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public Iterable<String> getChoices() {
        return this.choices;
    }

    public DocumentPropertyDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public boolean isMultilineText() {
        return this.multilineText;
    }

    protected String formatNumberValue(Number nbr, PropertyFormat format) {
        StringBuffer result = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.ENGLISH));
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setMaximumFractionDigits(this.decimals);
        decimalFormat.format(nbr, result, new FieldPosition(1));
        if (format == PropertyFormat.OLE && result.length() < 16) {
            if (result.indexOf(".") < 0) {
                result.append('.');
            }
            while (result.length() < 16) {
                result.append('0');
            }
        }
        return result.toString();
    }

    public String getFormattedValueString(PropertyFormat format) {
        if (this.value == null) {
            return "";
        }
        switch (this.dataType) {
            case TEXT: {
                return (String)this.value;
            }
            case CHOICE: {
                return (String)this.value;
            }
            case NUMBER: {
                return this.formatNumberValue((Number)this.value, format);
            }
            case DATETIME: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                return df.format((Date)this.value);
            }
            case BOOLEAN: {
                return format == PropertyFormat.OLE ? (((Boolean)this.value).booleanValue() ? "1" : "0") : ((Boolean)this.value != false ? "true" : "false");
            }
        }
        throw new IllegalArgumentException("Unknown data type.");
    }

    public String getFormattedMinValueString() {
        if (this.minValue == null) {
            return "";
        }
        return this.formatNumberValue(this.minValue, PropertyFormat.XML);
    }

    public String getFormattedMaxValueString() {
        if (this.maxValue == null) {
            return "";
        }
        return this.formatNumberValue(this.maxValue, PropertyFormat.XML);
    }
}

