/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webeditor.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.TagSupport;
import org.springframework.extensions.webeditor.taglib.TemplateProps;

public class AbstractTemplateTag
extends TagSupport {
    public static final long serialVersionUID = 3251970922970982753L;
    protected String urlPrefix = null;
    protected Boolean editingEnabled = null;
    protected Boolean debugEnabled = null;

    protected boolean isEditingEnabled() {
        if (this.editingEnabled == null) {
            Object enabledKey = this.pageContext.getRequest().getAttribute("wef_enabled");
            if (enabledKey != null && enabledKey instanceof Boolean) {
                this.editingEnabled = (Boolean)enabledKey;
            } else {
                this.editingEnabled = TemplateProps.isEditingEnabled();
                if (this.editingEnabled == null) {
                    this.editingEnabled = Boolean.FALSE;
                }
            }
        }
        return this.editingEnabled;
    }

    protected String getWebEditorUrlPrefix() {
        if (this.urlPrefix == null) {
            String prefix = (String)this.pageContext.getRequest().getAttribute("wef_url_prefix");
            if (prefix != null && prefix.length() > 0) {
                this.urlPrefix = prefix;
            } else {
                this.urlPrefix = TemplateProps.getUrlPrefix();
                if (this.urlPrefix == null) {
                    this.urlPrefix = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
                }
            }
        }
        return this.urlPrefix;
    }

    protected boolean isDebugEnabled() {
        if (this.debugEnabled == null) {
            Object debug = this.pageContext.getRequest().getAttribute("wef_debug");
            if (debug != null && debug instanceof Boolean) {
                this.debugEnabled = (Boolean)debug;
            } else {
                this.debugEnabled = TemplateProps.isDebugEnabled();
                if (this.debugEnabled == null) {
                    this.debugEnabled = Boolean.FALSE;
                }
            }
        }
        return this.debugEnabled;
    }

    protected String getToolbarLocation() {
        return (String)this.pageContext.getRequest().getAttribute("wef_toolbar_location");
    }

    protected String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            Object enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 16);
                    sb.append(soFar);
                }
                sb.append((String)enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public void release() {
        super.release();
        this.urlPrefix = null;
        this.debugEnabled = null;
    }
}

