/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.awe.tag;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.alfresco.web.awe.tag.AlfrescoTagUtil;
import org.alfresco.web.awe.tag.MarkedContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webeditor.taglib.AbstractTemplateTag;

public class MarkContentTag
extends AbstractTemplateTag {
    private static final long serialVersionUID = 1564711937667040715L;
    private static final Log logger = LogFactory.getLog(MarkContentTag.class);
    private String contentId;
    private String contentTitle;
    private String formId;
    private boolean nestedMarker = false;

    public String getId() {
        return this.contentId;
    }

    public void setId(String contentId) {
        this.contentId = contentId;
    }

    public String getTitle() {
        return this.contentTitle;
    }

    public void setTitle(String title) {
        this.contentTitle = title;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public boolean isNestedMarker() {
        return this.nestedMarker;
    }

    public void setNestedMarker(boolean nestedMarker) {
        this.nestedMarker = nestedMarker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doStartTag() throws JspException {
        if (this.isEditingEnabled()) {
            try {
                JspWriter out = this.pageContext.getOut();
                String urlPrefix = this.getWebEditorUrlPrefix();
                List<MarkedContent> markedContent = AlfrescoTagUtil.getMarkedContent(this.pageContext.getRequest());
                String markerIdPrefix = (String)this.pageContext.getRequest().getAttribute("awe_marker_id_prefix");
                String redirectUrl = AlfrescoTagUtil.calculateRedirectUrl((HttpServletRequest)this.pageContext.getRequest());
                String editMarkerId = markerIdPrefix + "-" + (markedContent.size() + 1);
                MarkedContent content = new MarkedContent(editMarkerId, this.contentId, this.contentTitle, this.formId, this.nestedMarker);
                markedContent.add(content);
                AlfrescoTagUtil.writeMarkContentHtml((Writer)out, urlPrefix, redirectUrl, content);
                if (!logger.isDebugEnabled()) return 0;
                logger.debug((Object)("Completed markContent rendering for: " + String.valueOf(content)));
                return 0;
            }
            catch (IOException ioe) {
                throw new JspException(ioe.toString());
            }
        } else {
            if (!logger.isDebugEnabled()) return 0;
            logger.debug((Object)"Skipping markContent rendering as editing is disabled");
        }
        return 0;
    }

    public void release() {
        super.release();
    }
}

