/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.alfresco.web.config.forms.Mode;
import org.alfresco.web.config.forms.Visibility;

class FieldVisibilityInstruction {
    private final Visibility showOrHide;
    private final String fieldId;
    private final List<Mode> forModes;

    public FieldVisibilityInstruction(String showOrHide, String fieldId, String modesString) {
        this.showOrHide = Visibility.visibilityFromString(showOrHide);
        this.fieldId = fieldId;
        this.forModes = modesString == null || modesString.length() == 0 ? Arrays.asList(Mode.values()) : Mode.modesFromString(modesString);
    }

    public Visibility getShowOrHide() {
        return this.showOrHide;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public List<Mode> getModes() {
        return Collections.unmodifiableList(this.forModes);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.showOrHide).append(" ").append(this.fieldId).append(" ").append(this.forModes);
        return result.toString();
    }
}

