/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webeditor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webeditor.WEFApplication;
import org.springframework.extensions.webeditor.WEFPlugin;
import org.springframework.extensions.webeditor.WEFResource;

public class WEFPluginRegistry {
    public static final String BEAN_NAME = "wefPluginRegistry";
    private static final Log logger = LogFactory.getLog(WEFPluginRegistry.class);
    private Map<String, WEFPlugin> plugins = new LinkedHashMap<String, WEFPlugin>(8);
    private Map<String, WEFApplication> applications = new LinkedHashMap<String, WEFApplication>(1);

    public void addPlugin(WEFPlugin plugin) {
        this.plugins.put(plugin.getName(), plugin);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added plugin to plugin registry: " + plugin));
        }
        if (plugin instanceof WEFApplication) {
            if (this.applications.size() > 0) {
                throw new IllegalStateException("Only one WEF application plugin is currently supported");
            }
            this.applications.put(plugin.getName(), (WEFApplication)plugin);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added application plugin to application registry: " + plugin));
            }
        }
    }

    public List<WEFPlugin> getPlugins() {
        return new ArrayList<WEFPlugin>(this.plugins.values());
    }

    public WEFPlugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public List<WEFApplication> getApplications() {
        return new ArrayList<WEFApplication>(this.applications.values());
    }

    public WEFApplication getApplication(String name) {
        return this.applications.get(name);
    }

    public List<WEFResource> getPluginResources() {
        LinkedHashMap<String, WEFResource> resourcesMap = new LinkedHashMap<String, WEFResource>(32);
        if (this.applications.size() > 0) {
            for (WEFApplication app : this.applications.values()) {
                this.buildResourceMap(app, resourcesMap);
            }
        } else {
            for (WEFPlugin plugin : this.plugins.values()) {
                this.buildResourceMap(plugin, resourcesMap);
            }
        }
        return new ArrayList<WEFResource>(resourcesMap.values());
    }

    public List<WEFResource> getAllResources(WEFResource resource) {
        LinkedHashMap<String, WEFResource> resourcesMap = new LinkedHashMap<String, WEFResource>(32);
        this.buildResourceMap(resource, resourcesMap);
        return new ArrayList<WEFResource>(resourcesMap.values());
    }

    protected void buildResourceMap(WEFResource resource, Map<String, WEFResource> resources) {
        for (WEFResource dependency : resource.getDependencies()) {
            this.buildResourceMap(dependency, resources);
        }
        if (!resources.containsKey(resource.getName())) {
            resources.put(resource.getName(), resource);
        }
    }
}

