/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.web.config.forms.FieldVisibilityManager;
import org.alfresco.web.config.forms.Mode;

public class FieldVisibilityManagerTest
extends TestCase {
    private static FieldVisibilityManager emptyFVM = new FieldVisibilityManager();
    private static FieldVisibilityManager firstOverrideFVM = new FieldVisibilityManager();
    private static FieldVisibilityManager secondOverrideFVM = new FieldVisibilityManager();
    private static FieldVisibilityManager thirdOverrideFVM = new FieldVisibilityManager();
    private static FieldVisibilityManager fourthOverrideFVM = new FieldVisibilityManager();
    private static FieldVisibilityManager fifthOverrideFVM = new FieldVisibilityManager();

    public FieldVisibilityManagerTest(String name) {
        super(name);
    }

    public void setUp() {
        firstOverrideFVM.addInstruction("hide", "A", null);
        firstOverrideFVM.addInstruction("hide", "B", "view");
        secondOverrideFVM.addInstruction("hide", "A", "edit");
        secondOverrideFVM.addInstruction("hide", "B", "create");
        thirdOverrideFVM.addInstruction("show", "C", "create");
        thirdOverrideFVM.addInstruction("show", "D", "");
        fourthOverrideFVM.addInstruction("hide", "D", null);
        fifthOverrideFVM.addInstruction("hide", "C", null);
    }

    public void testEmptyFVM() {
        this.assertFieldIsVisibleInModes(emptyFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(emptyFVM, "B", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(emptyFVM, "C", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(emptyFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(emptyFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)emptyFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testFirstOverrideFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM);
        this.assertFieldIsNotVisibleInModes(testFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "B", Mode.CREATE, Mode.EDIT);
        this.assertFieldIsNotVisibleInModes(testFVM, "B", Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "C", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A", "B"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testSecondOverrideFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM);
        this.assertFieldIsNotVisibleInModes(testFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "B", Mode.EDIT);
        this.assertFieldIsNotVisibleInModes(testFVM, "B", Mode.CREATE, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "C", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A", "B"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A", "B"), (Object)testFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testThirdOverrideFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM).combine(thirdOverrideFVM);
        this.assertFieldIsNotVisibleInModes(testFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "B", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "C", Mode.CREATE);
        this.assertFieldIsNotVisibleInModes(testFVM, "C", Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("C", "D"), (Object)testFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("D"), (Object)testFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("D"), (Object)testFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testFourthOverrideFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM).combine(thirdOverrideFVM).combine(fourthOverrideFVM);
        this.assertFieldIsNotVisibleInModes(testFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "B", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsVisibleInModes(testFVM, "C", Mode.CREATE);
        this.assertFieldIsNotVisibleInModes(testFVM, "C", Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("C"), (Object)testFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList(new String[0]), (Object)testFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList(new String[0]), (Object)testFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testFifthOverrideFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM).combine(thirdOverrideFVM).combine(fourthOverrideFVM).combine(fifthOverrideFVM);
        this.assertFieldIsNotVisibleInModes(testFVM, "A", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "B", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "C", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "D", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        this.assertFieldIsNotVisibleInModes(testFVM, "Z", Mode.CREATE, Mode.EDIT, Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList(new String[0]), (Object)testFVM.getFieldNamesVisibleInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList(new String[0]), (Object)testFVM.getFieldNamesVisibleInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(Arrays.asList(new String[0]), (Object)testFVM.getFieldNamesVisibleInMode(Mode.VIEW));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.CREATE));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.EDIT));
        FieldVisibilityManagerTest.assertEquals(null, (Object)testFVM.getFieldNamesHiddenInMode(Mode.VIEW));
    }

    public void testCheckVisibleFieldsforHideManagingFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM);
        List visibleCreateFields = testFVM.getFieldNamesVisibleInMode(Mode.CREATE);
        List visibleEditFields = testFVM.getFieldNamesVisibleInMode(Mode.EDIT);
        List visibleViewFields = testFVM.getFieldNamesVisibleInMode(Mode.VIEW);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are visible when there are no show tags.", (Object)visibleCreateFields);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are visible when there are no show tags.", (Object)visibleEditFields);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are visible when there are no show tags.", (Object)visibleViewFields);
    }

    public void testCheckVisibleFieldsforShowManagingFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM).combine(thirdOverrideFVM);
        List visibleCreateFields = testFVM.getFieldNamesVisibleInMode(Mode.CREATE);
        List visibleEditFields = testFVM.getFieldNamesVisibleInMode(Mode.EDIT);
        List visibleViewFields = testFVM.getFieldNamesVisibleInMode(Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("C", "D"), (Object)visibleCreateFields);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("D"), (Object)visibleEditFields);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("D"), (Object)visibleViewFields);
    }

    public void testCheckHiddenFieldsforHideManagingFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM);
        List hiddenCreateFields = testFVM.getFieldNamesHiddenInMode(Mode.CREATE);
        List hiddenEditFields = testFVM.getFieldNamesHiddenInMode(Mode.EDIT);
        List hiddenViewFields = testFVM.getFieldNamesHiddenInMode(Mode.VIEW);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A", "B"), (Object)hiddenCreateFields);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A"), (Object)hiddenEditFields);
        FieldVisibilityManagerTest.assertEquals(Arrays.asList("A", "B"), (Object)hiddenViewFields);
    }

    public void testCheckHiddenFieldsforShowManagingFVM() {
        FieldVisibilityManager testFVM = emptyFVM.combine(firstOverrideFVM).combine(secondOverrideFVM).combine(thirdOverrideFVM);
        List hiddenCreateFields = testFVM.getFieldNamesHiddenInMode(Mode.CREATE);
        List hiddenEditFields = testFVM.getFieldNamesHiddenInMode(Mode.EDIT);
        List hiddenViewFields = testFVM.getFieldNamesHiddenInMode(Mode.VIEW);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are hidden when there are any show tags.", (Object)hiddenCreateFields);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are hidden when there are any show tags.", (Object)hiddenEditFields);
        FieldVisibilityManagerTest.assertNull((String)"We cannot know what fields are hidden when there are any show tags.", (Object)hiddenViewFields);
    }

    private void assertFieldIsVisibleInModes(FieldVisibilityManager fvm, String fieldId, Mode ... modes) {
        for (Mode m : modes) {
            FieldVisibilityManagerTest.assertTrue((String)(fieldId + " should be visible in mode " + String.valueOf(m)), (boolean)fvm.isFieldVisible(fieldId, m));
        }
    }

    private void assertFieldIsNotVisibleInModes(FieldVisibilityManager fvm, String fieldId, Mode ... modes) {
        for (Mode m : modes) {
            FieldVisibilityManagerTest.assertFalse((String)(fieldId + " should NOT be visible in mode " + String.valueOf(m)), (boolean)fvm.isFieldVisible(fieldId, m));
        }
    }
}

