/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Map;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.ConstraintHandlersElementReader;
import org.alfresco.web.config.forms.FormConfigElement;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

class FormElementReader
implements ConfigElementReader {
    public static final String ATTR_APPEARANCE = "appearance";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABEL_ID = "label-id";
    public static final String ATTR_FOR_MODE = "for-mode";
    public static final String ATTR_FORM_ID = "id";
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_MESSAGE_ID = "message-id";
    public static final String ATTR_EVENT = "event";
    public static final String ATTR_VALIDATION_HANDLER = "validation-handler";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NAME_ID = "id";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_SUBMISSION_URL = "submission-url";
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FORCE = "force";
    public static final String ELEMENT_FORM = "form";
    public static final String ELEMENT_HIDE = "hide";
    public static final String ELEMENT_SHOW = "show";

    FormElementReader() {
    }

    public ConfigElement parse(Element formElement) {
        FormConfigElement result = null;
        if (formElement == null) {
            return null;
        }
        String name = formElement.getName();
        if (!name.equals(ELEMENT_FORM)) {
            throw new ConfigException(this.getClass().getName() + " can only parse form elements, the element passed was '" + name + "'");
        }
        result = new FormConfigElement();
        this.parseFormId(formElement, result);
        this.parseSubmissionURL(formElement, result);
        this.parseFormTag(formElement, result);
        this.parseFieldVisibilityTag(formElement, result);
        this.parseAppearanceTag(formElement, result);
        return result;
    }

    private void parseAppearanceTag(Element formElement, FormConfigElement result) {
        this.parseSetTags(formElement, result);
        this.parseFieldTags(formElement, result);
    }

    private void parseFieldTags(Element formElement, FormConfigElement result) {
        for (Object fieldObj : formElement.selectNodes("./appearance/field")) {
            Element fieldElem = (Element)fieldObj;
            ArrayList<Attribute> fieldAttributes = new ArrayList<Attribute>();
            for (Object obj : fieldElem.selectNodes("./@*")) {
                fieldAttributes.add((Attribute)obj);
            }
            ArrayList<String> fieldAttributeNames = new ArrayList<String>();
            ArrayList<String> fieldAttributeValues = new ArrayList<String>();
            String fieldIdValue = null;
            for (Attribute attribute : fieldAttributes) {
                String nextAttributeName = attribute.getName();
                String nextAttributeValue = attribute.getValue();
                if (nextAttributeName.equals("id")) {
                    fieldIdValue = nextAttributeValue;
                    continue;
                }
                fieldAttributeNames.add(nextAttributeName);
                fieldAttributeValues.add(nextAttributeValue);
            }
            if (fieldIdValue == null) {
                throw new ConfigException("<field> node missing mandatory id attribute.");
            }
            result.addField(fieldIdValue, fieldAttributeNames, fieldAttributeValues);
            ArrayList<Element> controlObjs = new ArrayList<Element>();
            for (Object obj : fieldElem.selectNodes("./control")) {
                controlObjs.add((Element)obj);
            }
            if (!controlObjs.isEmpty()) {
                Element element = (Element)controlObjs.get(0);
                String templateValue = element.attributeValue(ATTR_TEMPLATE);
                ArrayList<String> controlParamNames = new ArrayList<String>();
                ArrayList<String> controlParamValues = new ArrayList<String>();
                for (Object paramObj : element.selectNodes("./control-param")) {
                    Element paramElem = (Element)paramObj;
                    controlParamNames.add(paramElem.attributeValue(ATTR_NAME));
                    controlParamValues.add(paramElem.getTextTrim());
                }
                result.addControlForField(fieldIdValue, templateValue, controlParamNames, controlParamValues);
            }
            ConstraintHandlersElementReader constraintHandlersElementReader = new ConstraintHandlersElementReader();
            for (Object constraintHandlerObj : fieldElem.selectNodes("./constraint-handlers")) {
                Element constraintHandlers = (Element)constraintHandlerObj;
                ConfigElement confElem = constraintHandlersElementReader.parse(constraintHandlers);
                ConstraintHandlersConfigElement constraintHandlerCE = (ConstraintHandlersConfigElement)confElem;
                Map constraintItems = constraintHandlerCE.getItems();
                for (String key : constraintItems.keySet()) {
                    ConstraintHandlerDefinition defn = (ConstraintHandlerDefinition)constraintItems.get(key);
                    result.addConstraintForField(fieldIdValue, defn.getType(), defn.getMessage(), defn.getMessageId(), defn.getValidationHandler(), defn.getEvent());
                }
            }
        }
    }

    private void parseSetTags(Element formElement, FormConfigElement result) {
        for (Object setObj : formElement.selectNodes("./appearance/set")) {
            Element setElem = (Element)setObj;
            String setId = setElem.attributeValue("id");
            String parentSetId = setElem.attributeValue(ATTR_PARENT);
            String appearance = setElem.attributeValue(ATTR_APPEARANCE);
            String label = setElem.attributeValue(ATTR_LABEL);
            String labelId = setElem.attributeValue(ATTR_LABEL_ID);
            String template = setElem.attributeValue(ATTR_TEMPLATE);
            result.addSet(setId, parentSetId, appearance, label, labelId, template);
        }
    }

    private void parseFieldVisibilityTag(Element formElement, FormConfigElement result) {
        for (Object obj : formElement.selectNodes("./field-visibility/show|./field-visibility/hide")) {
            Element showOrHideElem = (Element)obj;
            String nodeName = showOrHideElem.getName();
            String fieldId = showOrHideElem.attributeValue("id");
            String mode = showOrHideElem.attributeValue(ATTR_FOR_MODE);
            String forceString = showOrHideElem.attributeValue(ATTR_FORCE);
            result.addFieldVisibility(nodeName, fieldId, mode, forceString);
        }
    }

    private void parseFormTag(Element formElement, FormConfigElement result) {
        for (Object obj : formElement.selectNodes("./edit-form|./view-form|./create-form")) {
            Element editOrViewOrCreateFormElem = (Element)obj;
            String nodeName = editOrViewOrCreateFormElem.getName();
            String template = editOrViewOrCreateFormElem.attributeValue(ATTR_TEMPLATE);
            result.setFormTemplate(nodeName, template);
        }
    }

    private void parseSubmissionURL(Element formElement, FormConfigElement result) {
        String submissionURL = formElement.attributeValue(ATTR_SUBMISSION_URL);
        result.setSubmissionURL(submissionURL);
    }

    private void parseFormId(Element formElement, FormConfigElement result) {
        String formId = formElement.attributeValue("id");
        result.setFormId(formId);
    }
}

