/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.web.config.forms.Control;
import org.alfresco.web.config.forms.ControlParam;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class DefaultControlsConfigElement
extends ConfigElementAdapter {
    public static final String CONFIG_ELEMENT_ID = "default-controls";
    private static final long serialVersionUID = -6758804774427314050L;
    private final Map<String, Control> datatypeDefCtrlMappings = new LinkedHashMap();

    public DefaultControlsConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public DefaultControlsConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the default-controls config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        List nextControlParams;
        Control nextDefaultControls;
        String nextTemplate;
        if (configElement == null) {
            return this;
        }
        DefaultControlsConfigElement otherDCCElement = (DefaultControlsConfigElement)configElement;
        DefaultControlsConfigElement result = new DefaultControlsConfigElement();
        for (String nextDataType : this.datatypeDefCtrlMappings.keySet()) {
            nextTemplate = this.getTemplateFor(nextDataType);
            nextDefaultControls = (Control)this.datatypeDefCtrlMappings.get(nextDataType);
            nextControlParams = null;
            if (nextDefaultControls != null) {
                nextControlParams = nextDefaultControls.getParamsAsList();
            }
            result.addDataMapping(nextDataType, nextTemplate, nextControlParams);
        }
        for (String nextDataType : otherDCCElement.datatypeDefCtrlMappings.keySet()) {
            nextTemplate = otherDCCElement.getTemplateFor(nextDataType);
            nextDefaultControls = (Control)otherDCCElement.datatypeDefCtrlMappings.get(nextDataType);
            nextControlParams = null;
            if (nextDefaultControls != null) {
                nextControlParams = nextDefaultControls.getParamsAsList();
            }
            result.addDataMapping(nextDataType, nextTemplate, nextControlParams);
        }
        return result;
    }

    void addDataMapping(String dataType, String template, List<ControlParam> parameters) {
        if (parameters == null) {
            parameters = Collections.emptyList();
        }
        Control newControl = new Control(template);
        for (ControlParam controlParam : parameters) {
            newControl.addControlParam(controlParam);
        }
        this.datatypeDefCtrlMappings.put(dataType, newControl);
    }

    public String[] getItemNames() {
        return this.getItemNamesAsList().toArray(new String[0]);
    }

    public List<String> getItemNamesAsList() {
        Set result = this.datatypeDefCtrlMappings.keySet();
        ArrayList resultList = new ArrayList(result);
        return Collections.unmodifiableList(resultList);
    }

    public Map<String, Control> getItems() {
        return Collections.unmodifiableMap(this.datatypeDefCtrlMappings);
    }

    public String getTemplateFor(String dataType) {
        Control ctrl = (Control)this.datatypeDefCtrlMappings.get(dataType);
        if (ctrl == null) {
            return null;
        }
        return ctrl.getTemplate();
    }

    public ControlParam[] getControlParamsFor(String dataType) {
        return this.getControlParamsAsListFor(dataType).toArray(new ControlParam[0]);
    }

    public List<ControlParam> getControlParamsAsListFor(String dataType) {
        return Collections.unmodifiableList(((Control)this.datatypeDefCtrlMappings.get(dataType)).getParamsAsList());
    }
}

