/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.Iterator;
import org.alfresco.web.config.forms.ConstraintHandlersConfigElement;
import org.alfresco.web.config.forms.ConstraintHandlersElementReader;
import org.alfresco.web.config.forms.DefaultControlsConfigElement;
import org.alfresco.web.config.forms.DefaultControlsElementReader;
import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.DependenciesElementReader;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormElementReader;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class FormsElementReader
implements ConfigElementReader {
    public static final String ATTR_NAME_ID = "id";
    public static final String ELEMENT_FORMS = "forms";

    public ConfigElement parse(Element formsElement) {
        FormsConfigElement result = null;
        if (formsElement == null) {
            return null;
        }
        String name = formsElement.getName();
        if (!name.equals(ELEMENT_FORMS)) {
            throw new ConfigException(this.getClass().getName() + " can only parse forms elements, the element passed was '" + name + "'");
        }
        result = new FormsConfigElement();
        Iterator iterator = formsElement.selectNodes("./form").iterator();
        while (iterator.hasNext()) {
            FormElementReader formReader = new FormElementReader();
            Object obj = iterator.next();
            Element formElement = (Element)obj;
            FormConfigElement form = (FormConfigElement)formReader.parse(formElement);
            if (form.getId() == null) {
                result.setDefaultForm(form);
                continue;
            }
            result.addFormById(form, form.getId());
        }
        for (Object obj : formsElement.selectNodes("./default-controls")) {
            Element defltCtrlsElement = (Element)obj;
            DefaultControlsElementReader defltCtrlsReader = new DefaultControlsElementReader();
            DefaultControlsConfigElement defltCtrlsCE = (DefaultControlsConfigElement)defltCtrlsReader.parse(defltCtrlsElement);
            result.setDefaultControls(defltCtrlsCE);
        }
        for (Object obj : formsElement.selectNodes("./constraint-handlers")) {
            Element constraintHandlersElement = (Element)obj;
            ConstraintHandlersElementReader constraintHandlersReader = new ConstraintHandlersElementReader();
            ConstraintHandlersConfigElement constraintHandlersCE = (ConstraintHandlersConfigElement)constraintHandlersReader.parse(constraintHandlersElement);
            result.setConstraintHandlers(constraintHandlersCE);
        }
        for (Object obj : formsElement.selectNodes("./dependencies")) {
            Element depsElement = (Element)obj;
            DependenciesElementReader depsReader = new DependenciesElementReader();
            DependenciesConfigElement depsCE = (DependenciesConfigElement)depsReader.parse(depsElement);
            result.setDependencies(depsCE);
        }
        return result;
    }
}

