/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts.forms;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.servlet.LocalTestRunAsAuthenticatorFactory;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.web.config.forms.FormConfigElement;
import org.alfresco.web.config.forms.FormField;
import org.alfresco.web.config.forms.FormsConfigElement;
import org.alfresco.web.config.forms.NodeTypeEvaluator;
import org.alfresco.web.scripts.forms.FormUIGet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ConfigSource;
import org.springframework.extensions.config.source.ClassPathConfigSource;
import org.springframework.extensions.config.xml.XMLConfigService;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.ResponseStatus;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;

public class FormUIGetRestApiIT
extends TestCase {
    private static final Log log = LogFactory.getLog(FormUIGetRestApiIT.class);
    private static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/web-scripts-application-context-webframework-test.xml"};
    private static ClassPathXmlApplicationContext ctx = (ClassPathXmlApplicationContext)ApplicationContextHelper.getApplicationContext((String[])CONFIG_LOCATIONS);
    private static TestWebScriptServer server = (TestWebScriptServer)ctx.getBean("webscripts.web.framework.test");
    protected NodeService nodeService;
    protected FileFolderService fileFolderService;
    protected Repository repositoryHelper;
    protected NodeRef containerNodeRef;
    protected TransactionService transactionService;
    private NodeRef folderWithoutAspect = null;
    private NodeRef folderWithAspect = null;

    public void setUp() throws Exception {
        super.setUp();
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService");
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        server.setServletAuthenticatorFactory((ServletAuthenticatorFactory)new LocalTestRunAsAuthenticatorFactory());
        NodeRef companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        String guid = GUID.generate();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.folderWithoutAspect = this.fileFolderService.create(companyHomeNodeRef, "folder_" + guid, ContentModel.TYPE_FOLDER).getNodeRef();
        FormUIGetRestApiIT.assertNotNull((String)"Doesn't create folder", (Object)this.folderWithoutAspect);
        this.folderWithAspect = this.fileFolderService.create(companyHomeNodeRef, "folder_aspect_" + guid, ContentModel.TYPE_FOLDER).getNodeRef();
        FormUIGetRestApiIT.assertNotNull((String)"Doesn't create folder", (Object)this.folderWithoutAspect);
        HashMap<QName, String> aspectProps = new HashMap<QName, String>(1);
        aspectProps.put(ContentModel.PROP_SUBJECT, "Test subject");
        this.nodeService.addAspect(this.folderWithAspect, ContentModel.ASPECT_DUBLINCORE, aspectProps);
    }

    public void tearDown() {
        if (this.folderWithoutAspect != null && this.fileFolderService.exists(this.folderWithoutAspect)) {
            this.fileFolderService.delete(this.folderWithoutAspect);
        }
        if (this.folderWithAspect != null && this.fileFolderService.exists(this.folderWithAspect)) {
            this.fileFolderService.delete(this.folderWithAspect);
        }
    }

    public void testMNT11660() throws Exception {
        FormUIGetExtend formUIGet = (FormUIGetExtend)((Object)ctx.getBean("webscript.org.alfresco.test.components.form.form.get"));
        FormUIGetRestApiIT.assertNotNull((String)"'FormUIGetExtend' bean for test is null.", (Object)((Object)formUIGet));
        ClassPathConfigSource configSource = new ClassPathConfigSource("test-config-custom-forms.xml");
        XMLConfigService svc = new XMLConfigService((ConfigSource)configSource);
        svc.initConfig();
        formUIGet.setConfigService((ConfigService)svc);
        TestWebScriptServer.GetRequest requestWithAspect = new TestWebScriptServer.GetRequest("/test/components/form?htmlid=template_default-formContainer&itemKind=node&itemId=" + this.folderWithAspect.toString() + "&formId=null&mode=view");
        TestWebScriptServer.Response rspFormWithAspect = server.submitRequest(requestWithAspect.getMethod(), requestWithAspect.getFullUri(), requestWithAspect.getHeaders(), requestWithAspect.getBody(), requestWithAspect.getEncoding(), requestWithAspect.getType());
        FormUIGetRestApiIT.assertEquals((String)("The status of response is " + rspFormWithAspect.getStatus()), (int)200, (int)rspFormWithAspect.getStatus());
        String contentWithAspect = rspFormWithAspect.getContentAsString();
        log.info((Object)("Response form for node with dublincore aspect status is " + rspFormWithAspect.getStatus() + " content is " + contentWithAspect));
        FormUIGetRestApiIT.assertNotNull((String)"Response content for 'contentWithAspect' is null", (Object)contentWithAspect);
        FormUIGetRestApiIT.assertTrue((String)("Return the following content: " + contentWithAspect), (boolean)contentWithAspect.contains("My Set"));
        TestWebScriptServer.GetRequest requestWithoutAspect = new TestWebScriptServer.GetRequest("/test/components/form?htmlid=template_default-formContainer&itemKind=node&itemId=" + this.folderWithoutAspect.toString() + "&formId=null&mode=view");
        TestWebScriptServer.Response rspFormWithoutAspect = server.submitRequest(requestWithoutAspect.getMethod(), requestWithoutAspect.getFullUri(), requestWithoutAspect.getHeaders(), requestWithoutAspect.getBody(), requestWithoutAspect.getEncoding(), requestWithoutAspect.getType());
        FormUIGetRestApiIT.assertEquals((String)("The status of response is " + rspFormWithoutAspect.getStatus()), (int)200, (int)rspFormWithoutAspect.getStatus());
        String contentWithoutAspect = rspFormWithoutAspect.getContentAsString();
        log.info((Object)("Response form for node without aspect status is " + rspFormWithoutAspect.getStatus() + " content is " + contentWithoutAspect));
        FormUIGetRestApiIT.assertNotNull((String)"Response content for 'contentWithoutAspect' is null", (Object)contentWithoutAspect);
        FormUIGetRestApiIT.assertFalse((String)("Return the following content: " + contentWithoutAspect), (boolean)contentWithoutAspect.contains("My Set"));
    }

    private static class FormUIGetExtend
    extends FormUIGet {
        private FormUIGetExtend() {
        }

        protected FormConfigElement getFormConfig(String itemId, String formId) {
            FormConfigElement formConfig = null;
            Config configResult = this.configService.getConfig((Object)itemId);
            FormsConfigElement formsConfig = (FormsConfigElement)configResult.getConfigElement("forms");
            TestCase.assertNotNull((String)"The ConfigElement object doesn't exist", (Object)formsConfig);
            if (formsConfig != null && formsConfig != null) {
                if (formId != null && formId.length() > 0) {
                    formConfig = formsConfig.getForm(formId);
                }
                if (formConfig == null) {
                    formConfig = formsConfig.getDefaultForm();
                }
            }
            TestCase.assertNotNull((String)"The ConfigElement object doesn't exist", formConfig);
            return formConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getStringFromInputStream(InputStream is) {
            BufferedReader br = null;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            TestCase.assertTrue((String)"StringBuilder has 0 length", (sb.length() > 0 ? 1 : 0) != 0);
            return sb.toString();
        }

        protected Response retrieveFormDefinition(String itemKind, String itemId, List<String> visibleFields, FormConfigElement formConfig) {
            Response response = null;
            try {
                TestCase.assertEquals((String)"Parameter 'itemKind' isn't 'node' value", (String)"node", (String)itemKind);
                TestCase.assertFalse((String)"itemId is empty", (itemId != null && itemId.isEmpty() ? 1 : 0) != 0);
                TestCase.assertTrue((String)"Visible fields are empty", (visibleFields.size() > 0 ? 1 : 0) != 0);
                TestCase.assertEquals((String)"Form config 'name' field isn't 'form' value", (String)"form", (String)formConfig.getName());
                ByteArrayInputStream bais = this.generateFormDefPostBody(itemKind, itemId, visibleFields, formConfig);
                TestCase.assertTrue((String)"Can't read bytes from ByteArrayInputStream ", (bais.available() > 0 ? 1 : 0) != 0);
                String json = this.getStringFromInputStream(bais);
                log.info((Object)("Request 'formdefinitions' json is: " + json));
                TestWebScriptServer.PostRequest request = new TestWebScriptServer.PostRequest("/api/formdefinitions", json, "application/json");
                TestWebScriptServer.Response responseTest = server.submitRequest(request.getMethod(), request.getFullUri(), request.getHeaders(), request.getBody(), request.getEncoding(), request.getType());
                if (responseTest.getStatus() == 200) {
                    JSONObject jsonParsedObject = new JSONObject(new JSONTokener(responseTest.getContentAsString()));
                    TestCase.assertNotNull((String)"JSON from responseTest is null", (Object)jsonParsedObject);
                    Object dataObj = jsonParsedObject.get("data");
                    TestCase.assertEquals(JSONObject.class, dataObj.getClass());
                    JSONObject rootDataObject = (JSONObject)dataObj;
                    String item = (String)rootDataObject.get("item");
                    String submissionUrl = (String)rootDataObject.get("submissionUrl");
                    String type = (String)rootDataObject.get("type");
                    JSONObject definitionObject = (JSONObject)rootDataObject.get("definition");
                    JSONObject formDataObject = (JSONObject)rootDataObject.get("formData");
                    TestCase.assertNotNull((String)"Item is null ", (Object)item);
                    TestCase.assertNotNull((String)"Submission url is null ", (Object)submissionUrl);
                    TestCase.assertNotNull((String)"Type is null ", (Object)type);
                    TestCase.assertNotNull((String)"Definition is null ", (Object)definitionObject);
                    TestCase.assertNotNull((String)"Form data is null ", (Object)formDataObject);
                    log.info((Object)("Response form 'formdefinitions' json 'data' is: " + String.valueOf(dataObj)));
                    ResponseStatus status = new ResponseStatus();
                    status.setCode(responseTest.getStatus());
                    TestCase.assertFalse((String)"Response content is empty", (boolean)responseTest.getContentAsString().isEmpty());
                    response = new Response(responseTest.getContentAsString(), status);
                    TestCase.assertNotNull((String)"Response data is null.", (Object)response.getText());
                } else {
                    TestCase.assertEquals((String)"Response /api/formdefinitions is not 200 status", (int)200, (int)responseTest.getStatus());
                }
            }
            catch (Exception e) {
                log.error((Object)("Response form 'formdefinitions' exception : " + e.getMessage()));
            }
            return response;
        }

        protected FormUIGet.Field generateFieldModel(FormUIGet.ModelContext context, String fieldName, FormField fieldConfig) {
            FormUIGet.Field field = null;
            try {
                if (this.isFieldAmbiguous(context, fieldName)) {
                    field = this.generateTransientFieldModel(fieldName, "/org/alfresco/components/form/controls/ambiguous.ftl");
                } else {
                    JSONObject fieldDefinition = this.discoverFieldDefinition(context, fieldName);
                    if (fieldDefinition != null) {
                        field = new FormUIGet.Field((FormUIGet)this);
                        this.processFieldIdentification(context, field, fieldDefinition, fieldConfig);
                        this.processFieldState(context, field, fieldDefinition, fieldConfig);
                        this.processFieldText(context, field, fieldDefinition, fieldConfig);
                        this.processFieldData(context, field, fieldDefinition, fieldConfig);
                        this.processFieldContent(context, field, fieldDefinition, fieldConfig);
                    } else {
                        field = this.generateTransientFieldModel(context, fieldName, fieldDefinition, fieldConfig);
                    }
                }
            }
            catch (JSONException je) {
                field = null;
                log.error((Object)("Generate field model exception: " + je.getMessage()));
            }
            log.info((Object)("Generated field model " + fieldName + " is null"));
            return field;
        }
    }

    public static class NodeTypeEvaluatorExtend
    extends NodeTypeEvaluator {
        protected String callMetadataService(String nodeString) throws ConnectorServiceException {
            TestWebScriptServer.GetRequest request = new TestWebScriptServer.GetRequest("/api/metadata?nodeRef=" + nodeString + "&shortQNames=true");
            TestWebScriptServer.Response response = null;
            String jsonResponse = null;
            try {
                response = server.submitRequest(request.getMethod(), request.getFullUri(), request.getHeaders(), request.getBody(), request.getEncoding(), request.getType());
                if (response != null) {
                    jsonResponse = response.getContentAsString();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AlfrescoRuntimeException(e.getMessage());
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException(e.getMessage());
            }
            TestCase.assertNotNull((String)"Response /api/metadata is null", (Object)jsonResponse);
            log.info((Object)("Response /api/metadata json is: " + jsonResponse));
            return jsonResponse;
        }
    }
}

