/*
 * Decompiled with CFR 0.152.
 */
package org.customer;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.customer.AbstractCustomerTag;
import org.json.JSONException;
import org.json.JSONObject;

public class PropertyTag
extends AbstractCustomerTag {
    private static final long serialVersionUID = -7972734141482504413L;
    private static final Log logger = LogFactory.getLog(PropertyTag.class);
    private String property;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String name) {
        this.property = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            String url = this.getRepoUrl() + "/service/api/metadata?nodeRef=" + this.getNodeRef() + "&shortQNames=true";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting metadata from: " + url));
            }
            HttpClient client = this.getHttpClient();
            GetMethod getContent = new GetMethod(url);
            getContent.setDoAuthentication(true);
            try {
                JSONObject json;
                JSONObject props;
                client.executeMethod((HttpMethod)getContent);
                String jsonResponse = getContent.getResponseBodyAsString();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)jsonResponse);
                }
                if ((props = (json = new JSONObject(jsonResponse)).getJSONObject("properties")).has(this.property)) {
                    out.write(props.getString(this.property));
                }
            }
            finally {
                getContent.releaseConnection();
            }
        }
        catch (IOException ioe) {
            throw new JspException(ioe.toString());
        }
        catch (JSONException je) {
            throw new JspException(je.toString());
        }
        return 0;
    }

    public void release() {
        super.release();
        this.property = null;
    }
}

