/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.publish;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

public class RenditionsFinder
extends AbstractNodeFinder {
    private NodeService nodeService;

    public void init() {
        super.init();
        this.nodeService = this.serviceRegistry.getNodeService();
    }

    public Set<NodeRef> findFrom(NodeRef thisNode) {
        Set<NodeRef> result = Collections.emptySet();
        if (this.nodeService.exists(thisNode) && this.nodeService.hasAspect(thisNode, RenditionModel.ASPECT_RENDITIONED)) {
            result = new HashSet<NodeRef>();
            List renditions = this.nodeService.getChildAssocs(thisNode, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef rendition : renditions) {
                result.add(rendition.getChildRef());
            }
        }
        return result;
    }
}

