/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LoadWebSiteDataGet
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(LoadWebSiteDataGet.class);
    private static final String COMPONENT_DOCUMENT_LIBRARY = "documentLibrary";
    private static final String ARG_SITE_NAME = "site";
    private static final String ARG_PREVIEW = "preview";
    private static final String ARG_IMPORT_ID = "importid";
    private static final String DEFAULT_IMPORT_ID = "financial";
    private ImporterService importerService;
    private NodeService nodeService;
    private SiteService siteService;
    private FileFolderService fileFolderService;
    private Map<String, String> importFileLocations;

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setImportFileLocations(Map<String, String> importFileLocations) {
        this.importFileLocations = importFileLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        SiteInfo site;
        String siteName = null;
        if (req.getParameter(ARG_SITE_NAME) == null) {
            throw new WebScriptException(400, "No site name specified.");
        }
        siteName = req.getParameter(ARG_SITE_NAME);
        boolean preview = false;
        if (req.getParameter(ARG_PREVIEW) != null) {
            String value = req.getParameter(ARG_PREVIEW);
            preview = Boolean.parseBoolean(value);
        }
        String importId = DEFAULT_IMPORT_ID;
        if (req.getParameter(ARG_IMPORT_ID) != null) {
            importId = req.getParameter(ARG_IMPORT_ID);
        }
        if ((site = this.siteService.getSite(siteName)) == null) {
            throw new WebScriptException(400, "The site specified (" + siteName + ") does not exist.");
        }
        NodeRef docLib = this.siteService.getContainer(siteName, COMPONENT_DOCUMENT_LIBRARY);
        boolean success = true;
        if (docLib != null && this.isDataLoaded(docLib)) {
            success = false;
        } else if (!preview) {
            InputStream is;
            String importFileLocation = this.importFileLocations.get(importId);
            if (importFileLocation == null) {
                throw new WebScriptException(400, "The import file location for import id " + importId + " could not be found.");
            }
            if (docLib == null) {
                docLib = this.siteService.createContainer(siteName, COMPONENT_DOCUMENT_LIBRARY, WebSiteModel.TYPE_WEBSITE_CONTAINER, null);
            } else if (!WebSiteModel.TYPE_WEBSITE_CONTAINER.equals((Object)this.nodeService.getType(docLib))) {
                this.nodeService.setType(docLib, WebSiteModel.TYPE_WEBSITE_CONTAINER);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Importing " + importFileLocation + " into site " + siteName));
            }
            if ((is = LoadWebSiteDataGet.class.getClassLoader().getResourceAsStream(importFileLocation)) == null) {
                throw new AlfrescoRuntimeException("The import file (" + importFileLocation + ") could not be found");
            }
            File acpFile = null;
            try {
                acpFile = File.createTempFile("temp", ".acp");
                FileOutputStream out = new FileOutputStream(acpFile);
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                    is.close();
                }
            }
            catch (IOException ioException) {
                throw new AlfrescoRuntimeException("The import file (" + importFileLocation + ") could not be opened.");
            }
            ACPImportPackageHandler importHandler = new ACPImportPackageHandler(acpFile, "UTF-8");
            Location location = new Location(docLib);
            this.importerService.importView((ImportPackageHandler)importHandler, location, null, null);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("success", success);
        model.put(ARG_PREVIEW, preview);
        if (success && preview) {
            model.put("importids", this.importFileLocations.keySet());
        }
        return model;
    }

    private boolean isDataLoaded(NodeRef docLib) {
        boolean result = false;
        if (this.fileFolderService.searchSimple(docLib, "Alfresco Quick Start") != null) {
            result = true;
        }
        return result;
    }
}

