/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.publish.PublishService;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishQueueProcessor {
    private static final Log log = LogFactory.getLog(PublishQueueProcessor.class);
    private TransactionService transactionService;
    private SearchService searchService;
    private PublishService publishService;
    private RepositoryState repositoryState;
    private JobLockService jobLockService;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.PublishQueueProcessor");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.repositoryState.isBootstrapping()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PublishQueue processor can not be executed while the repository is bootstrapping");
            }
            return;
        }
        LockCallback lockCallback = new LockCallback(this);
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
            if (lockToken == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Can't get lock.");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities publishQueue processor started");
            }
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, (JobLockService.JobLockRefreshCallback)lockCallback);
            this.runInternal();
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities publishQueue processor completed");
            }
        }
        catch (LockAcquisitionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities publishQueue processor already underway");
            }
        }
        catch (VmShutdownListener.VmShutdownException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities publishQueue processor aborted");
            }
        }
        finally {
            lockCallback.running.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    private void runInternal() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                PublishQueueProcessor.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object execute() throws Throwable {
                        try (ResultSet rs = null;){
                            rs = PublishQueueProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "TYPE:\"" + String.valueOf(WebSiteModel.TYPE_WEB_SITE) + "\"");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Running publish queue processor across " + rs.length() + " website nodes"));
                            }
                            for (ResultSetRow row : rs) {
                                PublishQueueProcessor.this.publishService.publishQueue(row.getNodeRef());
                            }
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)"System");
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPublishService(PublishService publishService) {
        this.publishService = publishService;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback(PublishQueueProcessor publishQueueProcessor) {
        }

        public boolean isActive() {
            return this.running.get();
        }

        public void lockReleased() {
            this.running.set(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock released : " + String.valueOf(LOCK_QNAME)));
            }
        }
    }
}

