/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VisitorFeedbackSummaryType
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(VisitorFeedbackSummaryType.class);
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, WebSiteModel.TYPE_VISITOR_FEEDBACK_SUMMARY, (Behaviour)new JavaBehaviour((Object)this, "onUpdatePropertiesOnCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdatePropertiesOnCommit(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        NodeRef summarisedAsset = (NodeRef)after.get(PROP_SUMMARISED_ASSET);
        if (summarisedAsset != null && this.nodeService.exists(summarisedAsset)) {
            this.behaviourFilter.disableBehaviour(summarisedAsset, WebSiteModel.ASPECT_WEBASSET);
            try {
                Map props = this.nodeService.getProperties(summarisedAsset);
                Float averageRating = (Float)after.get(PROP_AVERAGE_RATING);
                Serializable commentCount = after.get(PROP_COMMENT_COUNT);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating web asset " + String.valueOf(summarisedAsset) + " with feedback summary. Average rating = " + averageRating + "; Comment count = " + String.valueOf(commentCount)));
                }
                int roundedRating = 0;
                if (averageRating != null) {
                    float actualRating = averageRating.floatValue();
                    roundedRating = Math.round(actualRating * 10.0f);
                }
                props.put(PROP_DERIVED_AVERAGE_RATING, roundedRating);
                props.put(PROP_DERIVED_COMMENT_COUNT, commentCount);
                this.nodeService.setProperties(summarisedAsset, props);
            }
            finally {
                this.behaviourFilter.enableBehaviour(summarisedAsset, WebSiteModel.ASPECT_WEBASSET);
            }
        }
    }
}

