/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaggableAspect
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(TaggableAspect.class);
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.ASPECT_TAGGABLE, (Behaviour)new JavaBehaviour((Object)this, "onUpdatePropertiesOnCommit", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdatePropertiesOnCommit(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ASPECT_WEBASSET) && !EqualsHelper.nullSafeEquals((Object)before.get(ContentModel.PROP_TAGS), (Object)after.get(ContentModel.PROP_TAGS))) {
            List tagIds = (List)((Object)after.get(ContentModel.PROP_TAGS));
            ArrayList<String> tags = new ArrayList<String>();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing tags on a webasset node (" + String.valueOf(nodeRef) + "). Category nodes are: " + String.valueOf(tagIds)));
            }
            if (tagIds != null) {
                for (NodeRef tagId : tagIds) {
                    if (!this.nodeService.exists(tagId)) continue;
                    tags.add((String)((Object)this.nodeService.getProperty(tagId, ContentModel.PROP_NAME)));
                }
            }
            this.behaviourFilter.disableBehaviour(nodeRef, ASPECT_WEBASSET);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting webasset tags to be " + String.valueOf(tags) + " on node " + String.valueOf(nodeRef)));
                }
                this.nodeService.setProperty(nodeRef, PROP_TAGS, tags);
            }
            finally {
                this.behaviourFilter.enableBehaviour(nodeRef, ASPECT_WEBASSET);
            }
        }
    }
}

