/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class WebsiteInfoGet
extends DeclarativeWebScript
implements WebSiteModel {
    private static final Log log = LogFactory.getLog(WebsiteInfoGet.class);
    private static final String PARAM_WEBSITE_ID = "websiteid";
    private NodeService nodeService;
    private SiteHelper siteHelper;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String websiteId = req.getParameter(PARAM_WEBSITE_ID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finding feedback folder for website " + websiteId));
        }
        if (websiteId == null || websiteId.length() == 0) {
            throw new WebScriptException(400, "No websiteid parameter specified.");
        }
        if (!NodeRef.isNodeRef((String)websiteId)) {
            throw new WebScriptException(400, "websiteid is not a valid Alfresco node reference. ( " + websiteId + ")");
        }
        NodeRef websiteNode = new NodeRef(websiteId);
        if (!this.nodeService.exists(websiteNode)) {
            throw new WebScriptException(400, "A node with the specified id does not exist in this repository. ( " + websiteId + ")");
        }
        String rootSectionId = websiteId;
        List childAssocs = this.nodeService.getChildAssocs(websiteNode, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"root"));
        if (!childAssocs.isEmpty()) {
            rootSectionId = ((ChildAssociationRef)childAssocs.get(0)).getChildRef().toString();
        }
        String feedbackFolderId = websiteId;
        SiteInfo siteInfo = this.siteHelper.getRelevantShareSite(websiteNode);
        if (siteInfo == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("A website node appears to have been created outside of a Share site. This is unsupported. Node id = " + websiteId));
            }
        } else {
            feedbackFolderId = this.siteHelper.getFeedbackList((String)((Object)this.nodeService.getProperty(websiteNode, ContentModel.PROP_NAME)), siteInfo.getShortName(), true).toString();
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("rootSectionId", rootSectionId);
        model.put("feedbackFolderId", feedbackFolderId);
        return model;
    }
}

