/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.CharQueue;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.MarkovChain;
import org.alfresco.module.org_alfresco_module_wcmquickstart.benchmark.TextGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class RandomTextGenerator
implements TextGenerator,
InitializingBean {
    private static Log logger = LogFactory.getLog(TextGenerator.class);
    public static final String FILTER_NON_STANDARD_REGEX = "[^\\da-zA-Z\\s]";
    public static final int DEFAULT_LINE_WIDTH = 65;
    public static final int DEFAULT_TOTAL_CHARACTERS = 300;
    public static final int DEFAULT_NAME_SIZE = 15;
    private int prefixLength = 10;
    private String sourceTextLocation;
    private MarkovChain chain1;
    private MarkovChain chain2;

    public int generateHTMLFile(String outputFile, int minParagraphs, int maxParagraphs, int minParagraphLength, int maxParagraphLength, int lineWidth) {
        int totalLength = 0;
        int numberOfParagraphs = this.randomNumber(minParagraphs, maxParagraphs);
        try {
            File file = new File(outputFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(file, false);
            out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n".getBytes());
            out.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">\n".getBytes());
            out.write("<head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n".getBytes());
            out.write(("<title>" + this.generateSentence(30, true) + "</title></head><body>\n").getBytes());
            for (int paragraph = 0; paragraph < numberOfParagraphs; ++paragraph) {
                int paragraphLength = this.randomNumber(minParagraphLength, maxParagraphLength);
                String paraText = this.generateText(paragraphLength, lineWidth, false) + "\n";
                totalLength += paraText.length();
                out.write(("<p>" + paraText + "</p>\n").getBytes());
            }
            out.write("</body>\n</html>".getBytes());
            out.close();
            return totalLength;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Failed to generate HTML file", (Throwable)e);
            return 0;
        }
        catch (IOException e) {
            logger.error((Object)"Failed to generate HTML file", (Throwable)e);
            return 0;
        }
    }

    public String generateHTMLString(int minParagraphs, int maxParagraphs, int minParagraphLength, int maxParagraphLength, int lineWidth) {
        int numberOfParagraphs = this.randomNumber(minParagraphs, maxParagraphs);
        StringBuffer sb = new StringBuffer();
        sb.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
        sb.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">\n");
        sb.append("<head>\n<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n");
        sb.append("<title>" + this.generateSentence(30, true) + "</title></head><body>\n");
        for (int paragraph = 0; paragraph < numberOfParagraphs; ++paragraph) {
            int paragraphLength = this.randomNumber(minParagraphLength, maxParagraphLength);
            sb.append("<p>");
            sb.append(this.generateText(paragraphLength, lineWidth, false) + "\n");
            sb.append("</p>\n");
        }
        sb.append("</body>\n</html>");
        return sb.toString();
    }

    public String generateTextString(int minParagraphs, int maxParagraphs, int minParagraphLength, int maxParagraphLength, int lineWidth) {
        int numberOfParagraphs = this.randomNumber(minParagraphs, maxParagraphs);
        StringBuffer sb = new StringBuffer();
        for (int paragraph = 0; paragraph < numberOfParagraphs; ++paragraph) {
            int paragraphLength = this.randomNumber(minParagraphLength, maxParagraphLength);
            sb.append(this.generateText(paragraphLength, lineWidth, false) + "\n\n");
        }
        return sb.toString();
    }

    public int generateTextFile(String outputFile, int minParagraphs, int maxParagraphs, int minParagraphLength, int maxParagraphLength, int lineWidth) {
        int totalLength = 0;
        int numberOfParagraphs = this.randomNumber(minParagraphs, maxParagraphs);
        try {
            File file = new File(outputFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(file, false);
            for (int paragraph = 0; paragraph < numberOfParagraphs; ++paragraph) {
                int paragraphLength = this.randomNumber(minParagraphLength, maxParagraphLength);
                String paraText = this.generateText(paragraphLength, lineWidth, false) + "\n";
                totalLength += paraText.length();
                out.write(paraText.getBytes());
            }
            out.close();
            return totalLength;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Failed to generate text file", (Throwable)e);
            return 0;
        }
        catch (IOException e) {
            logger.error((Object)"Failed to generate text file", (Throwable)e);
            return 0;
        }
    }

    private int randomNumber(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public String generateSentence() {
        return this.generateSentence(65, true);
    }

    public String generateSentence(int totalCharacters, boolean enforceFullWord) {
        return this.generateText(totalCharacters, totalCharacters, enforceFullWord).trim();
    }

    @Override
    public String generateName() {
        return this.generateName(15, true);
    }

    public String generateName(int totalCharacters, boolean enforceFullWord) {
        String text = this.generateText(totalCharacters, totalCharacters, enforceFullWord);
        text = this.filterNonStandardChars(text).trim();
        return this.flattenWhitespace(text);
    }

    private String filterNonStandardChars(String s) {
        return s.replaceAll(FILTER_NON_STANDARD_REGEX, "");
    }

    private String flattenWhitespace(String s) {
        return s.replaceAll(" +", " ");
    }

    public String generateText() {
        return this.generateText(300, 65, true);
    }

    public String generateText(int totalCharacters, int lineWidth, boolean enforceFullWord) {
        int c;
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        CharQueue queue = new CharQueue(this.prefixLength);
        float weight = 0.0f;
        queue.set(this.chain1.getBootstrapPrefix());
        sb.append(queue.toString());
        int width = 0;
        do {
            String prefix = queue.toString();
            c = this.chain1.get(prefix, random);
            int c2 = -1;
            if (this.chain2 != null) {
                c2 = this.chain2.get(prefix, random);
            }
            if (c == -1 && c2 == -1) break;
            if (this.chain2 != null) {
                if (c == -1) {
                    c = c2;
                } else if (c2 != -1 && random.nextFloat() < weight) {
                    c = c2;
                }
            }
            sb.append((char)c);
            queue.put((char)c);
            if (c != 32 || ++width <= lineWidth) continue;
            sb.append("\n");
            width = 0;
        } while ((weight = (float)((double)weight + 1.0 / (double)totalCharacters)) < 1.0f || Character.isLetter(c) && enforceFullWord);
        sb.append("\n");
        String generatedText = sb.toString();
        return generatedText.substring(this.prefixLength + 1, this.prefixLength + 2).toUpperCase() + generatedText.substring(this.prefixLength + 2);
    }

    private MarkovChain newMarkovChain() {
        try {
            InputStream input = new ClassPathResource(this.sourceTextLocation).getInputStream();
            if (input == null) {
                throw new IllegalArgumentException("Source Text not found: " + this.sourceTextLocation);
            }
            return new MarkovChain(input, this.prefixLength);
        }
        catch (FileNotFoundException fnfe) {
            throw new AlfrescoRuntimeException("File could not be found: " + this.sourceTextLocation, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.chain1 = this.newMarkovChain();
        this.chain2 = this.newMarkovChain();
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public void setSourceTextLocation(String sourceTextLocation) {
        this.sourceTextLocation = sourceTextLocation;
    }
}

