/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.AssetSerializerXmlImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AssetSerializerXmlImplTest
extends TestCase {
    private AssetSerializerXmlImpl testObject;

    protected void setUp() throws Exception {
        super.setUp();
        this.testObject = new AssetSerializerXmlImpl();
        NamespaceService namespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        ((NamespaceService)Mockito.doAnswer((Answer)new Answer<Collection<String>>(){

            public Collection<String> answer(InvocationOnMock invocation) throws Throwable {
                ArrayList<String> reply = new ArrayList<String>();
                reply.add("myapp");
                return reply;
            }
        }).when((Object)namespaceService)).getPrefixes((String)Mockito.any(String.class));
        this.testObject.setNamespaceService(namespaceService);
    }

    public void test1() throws Exception {
        StringWriter writer = new StringWriter();
        this.testObject.start((Writer)writer);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(QName.createQName((String)"uri", (String)"integerProperty"), new Integer(678));
        props.put(QName.createQName((String)"uri", (String)"longProperty"), new Long(6737436288L));
        props.put(QName.createQName((String)"uri", (String)"dateProperty"), new Date());
        props.put(QName.createQName((String)"uri", (String)"floatProperty"), new Float(132.435243));
        props.put(QName.createQName((String)"uri", (String)"doubleProperty"), new Double(1.324352E14));
        props.put(QName.createQName((String)"uri", (String)"noderefProperty"), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()));
        props.put(QName.createQName((String)"uri", (String)"textProperty"), "The \u0440\u0430\u0434\u0438\u0430\u0442\u043e\u0440 <sat> on the mat: first on one side; the on the other... \u2013 ");
        ArrayList<String> textList = new ArrayList<String>();
        textList.add("One");
        textList.add("Two");
        textList.add("Three");
        textList.add("Four");
        textList.add("Five");
        textList.add("Six");
        props.put(QName.createQName((String)"uri", (String)"textListProperty"), textList);
        ArrayList<Integer> intList = new ArrayList<Integer>();
        intList.add(1);
        intList.add(2);
        intList.add(3);
        intList.add(4);
        intList.add(5);
        intList.add(6);
        props.put(QName.createQName((String)"uri", (String)"intListProperty"), intList);
        props.put(QName.createQName((String)"uri", (String)"mapProperty"), new HashMap(props));
        this.testObject.writeNode(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()), QName.createQName((String)"uri", (String)"MyType"), props);
        this.testObject.end();
        System.out.println(writer.toString());
    }
}

