/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.contextparser.ContextParser;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;

public class PdfRenditionPathContextParser
extends ContextParser {
    private FileFolderService fileFolderService;
    private Repository repository;

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public String execute(NodeRef context) {
        NodeRef section = this.siteHelper.getRelevantSection(context);
        if (section == null) {
            return null;
        }
        List path = null;
        try {
            path = this.fileFolderService.getNamePath(this.repository.getCompanyHome(), section);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to retrieve section path information", (Throwable)e);
        }
        StringBuilder builder = new StringBuilder();
        boolean bFirst = true;
        for (FileInfo pathElement : path) {
            if (bFirst) {
                bFirst = false;
            } else {
                builder.append("/");
            }
            builder.append(pathElement.getName());
        }
        builder.append('/');
        String currentName = (String)((Object)this.nodeService.getProperty(context, ContentModel.PROP_NAME));
        String[] splitName = currentName.split("\\.");
        if (splitName.length == 1) {
            splitName[0] = splitName[0] + ".pdf";
        } else {
            splitName[splitName.length - 1] = "pdf";
        }
        bFirst = true;
        for (int i = 0; i < splitName.length; ++i) {
            if (!bFirst) {
                builder.append('.');
            }
            builder.append(splitName[i]);
            bFirst = false;
        }
        return builder.toString();
    }
}

