/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.webscript;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_wcmquickstart.util.SiteHelper;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class TranslationDetailsGet
extends DeclarativeWebScript {
    private static final String PARAM_NODEREF = "nodeRef";
    private static final String PARAM_LOCALES = "locales";
    private static final String PARAM_NODE_LOCALE = "nodeLocale";
    private static final String PARAM_TRANSLATIONS = "translations";
    private static final String PARAM_TRANSLATION_ENABLED = "translationEnabled";
    private static final String PARAM_TRANSLATION_PARENTS = "translationParents";
    private static final Log log = LogFactory.getLog(TranslationDetailsGet.class);
    private NodeService nodeService;
    private SiteHelper siteHelper;
    private MultilingualContentService multilingualContentService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteHelper(SiteHelper siteHelper) {
        this.siteHelper = siteHelper;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        NodeRef nodeParent;
        Map translations;
        HashMap<String, Object> model = new HashMap<String, Object>();
        String nodeRefParam = req.getParameter(PARAM_NODEREF);
        if (nodeRefParam == null || nodeRefParam.length() == 0) {
            throw new WebScriptException(404, "NodeRef not supplied but required");
        }
        NodeRef nodeRef = new NodeRef(nodeRefParam);
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(404, "NodeRef not found");
        }
        model.put(PARAM_NODEREF, nodeRef);
        NodeRef website = this.siteHelper.getRelevantWebSite(nodeRef);
        List<Locale> locales = this.siteHelper.getWebSiteLocales(website);
        model.put(PARAM_LOCALES, locales);
        boolean translationEnabled = false;
        Locale nodeLocale = null;
        if (this.multilingualContentService.isTranslation(nodeRef)) {
            translations = this.multilingualContentService.getTranslations(nodeRef);
            translationEnabled = true;
            nodeLocale = (Locale)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LOCALE);
        } else {
            translations = Collections.emptyMap();
        }
        model.put(PARAM_TRANSLATIONS, translations);
        model.put(PARAM_TRANSLATION_ENABLED, translationEnabled);
        HashMap<Locale, Pair> parents = new HashMap<Locale, Pair>();
        NodeRef current = nodeParent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        while (current != null && !this.siteHelper.isTranslationParentLimitReached(current)) {
            if (this.multilingualContentService.isTranslation(current)) {
                Map parentTranslations = this.multilingualContentService.getTranslations(current);
                for (Locale locale : parentTranslations.keySet()) {
                    if (parents.containsKey(locale)) continue;
                    Pair details = new Pair((Object)((NodeRef)parentTranslations.get(locale)), (Object)(current == nodeParent ? 1 : 0));
                    parents.put(locale, details);
                }
                if (nodeLocale == null && this.nodeService.hasAspect(current, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
                    nodeLocale = (Locale)this.nodeService.getProperty(current, ContentModel.PROP_LOCALE);
                }
            }
            current = this.nodeService.getPrimaryParent(current).getParentRef();
        }
        model.put(PARAM_TRANSLATION_PARENTS, parents);
        model.put(PARAM_NODE_LOCALE, nodeLocale);
        return model;
    }
}

