/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_wcmquickstart.jobs;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.feedback.FeedbackProcessorHandler;
import org.alfresco.module.org_alfresco_module_wcmquickstart.model.WebSiteModel;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedbackProcessor {
    private static final Log log = LogFactory.getLog(FeedbackProcessor.class);
    private RetryingTransactionHelper txHelper;
    private SearchService searchService;
    private NodeService nodeService;
    private Map<String, FeedbackProcessorHandler> handlers = new TreeMap<String, FeedbackProcessorHandler>();
    private RepositoryState repositoryState;
    private JobLockService jobLockService;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.module.org_alfresco_module_wcmquickstart.jobs.FeedbackProcessor");

    public void registerHandler(FeedbackProcessorHandler handler) {
        this.handlers.put(handler.getFeedbackType(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.repositoryState.isBootstrapping()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Feedback processor can not be executed while the repository is bootstrapping");
            }
            return;
        }
        LockCallback lockCallback = new LockCallback();
        String lockToken = null;
        try {
            lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
            if (lockToken == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Can't get lock.");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities feedback processor started");
            }
            this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, (JobLockService.JobLockRefreshCallback)lockCallback);
            this.runInternal();
            if (log.isDebugEnabled()) {
                log.trace((Object)"Activities feedback processor completed");
            }
        }
        catch (LockAcquisitionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities feedback processor already underway");
            }
        }
        catch (VmShutdownListener.VmShutdownException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Activities feedback processor aborted");
            }
        }
        finally {
            lockCallback.running.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
    }

    private void runInternal() {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                FeedbackProcessor.this.txHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object execute() throws Throwable {
                        try (ResultSet rs = null;){
                            rs = FeedbackProcessor.this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "@ws\\:ratingProcessed:\"false\"");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Running feedback processor across " + rs.length() + " feedback nodes"));
                            }
                            for (ResultSetRow row : rs) {
                                NodeRef feedback = row.getNodeRef();
                                String feedbackType = (String)((Object)FeedbackProcessor.this.nodeService.getProperty(feedback, WebSiteModel.PROP_FEEDBACK_TYPE));
                                if (feedbackType != null) {
                                    FeedbackProcessorHandler handler = FeedbackProcessor.this.handlers.get(feedbackType);
                                    if (handler != null) {
                                        if (!Boolean.FALSE.equals((Boolean)FeedbackProcessor.this.nodeService.getProperty(feedback, WebSiteModel.PROP_RATING_PROCESSED))) continue;
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("Processing feedback node " + feedback.toString() + " of feedback type " + feedbackType));
                                        }
                                        handler.processFeedback(feedback);
                                        FeedbackProcessor.this.nodeService.setProperty(feedback, WebSiteModel.PROP_RATING_PROCESSED, (Serializable)Boolean.TRUE);
                                        continue;
                                    }
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("Feedback processor handler can not be found for feedback type " + feedbackType + " on feedback node " + feedback.toString()));
                                    continue;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("Feedback type not specified for feedback node " + feedback.toString()));
                            }
                            for (FeedbackProcessorHandler handler : FeedbackProcessor.this.handlers.values()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Executing feedback handler callback for feedback type " + handler.getFeedbackType()));
                                }
                                handler.processorCallback();
                            }
                        }
                        return null;
                    }
                });
                return null;
            }
        }, (String)"System");
    }

    public void setTxHelper(RetryingTransactionHelper txHelper) {
        this.txHelper = txHelper;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRepositoryState(RepositoryState repositoryState) {
        this.repositoryState = repositoryState;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        public boolean isActive() {
            return this.running.get();
        }

        public void lockReleased() {
            this.running.set(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock released : " + String.valueOf(LOCK_QNAME)));
            }
        }
    }
}

